/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import vazkii.quark.base.handler.BiomeTypeConfigHandler;
import vazkii.quark.world.feature.UndergroundBiomes;
import vazkii.quark.world.world.MultiChunkFeatureGenerator;

public class UndergroundBiomeGenerator
extends MultiChunkFeatureGenerator {
    public final UndergroundBiomes.UndergroundBiomeInfo info;
    long seedXor;

    public UndergroundBiomeGenerator(UndergroundBiomes.UndergroundBiomeInfo info) {
        this.info = info;
        this.seedXor = info.biome.getClass().toString().hashCode();
    }

    @Override
    public boolean canGenerate(World world, int chunkX, int chunkZ) {
        return this.info.dims.canSpawnHere(world);
    }

    @Override
    public int getFeatureRadius() {
        return (int)Math.ceil(Math.max(this.info.minXSize + this.info.xVariation, this.info.minZSize + this.info.zVariation));
    }

    @Override
    public void generateChunkPart(BlockPos src, Random random, int chunkX, int chunkZ, World world) {
        int radiusX = this.info.minXSize + random.nextInt(this.info.xVariation);
        int radiusY = this.info.minYSize + random.nextInt(this.info.yVariation);
        int radiusZ = this.info.minZSize + random.nextInt(this.info.zVariation);
        this.apply(world, src, random, chunkX, chunkZ, radiusX, radiusY, radiusZ);
    }

    @Override
    public BlockPos[] getSourcesInChunk(Random random, int chunkX, int chunkZ, World world) {
        if (random.nextInt(this.info.rarity) == 0) {
            return new BlockPos[]{new BlockPos(chunkX * 16 + random.nextInt(16), this.info.minY + random.nextInt(this.info.maxY - this.info.minY), chunkZ * 16 + random.nextInt(16))};
        }
        return new BlockPos[0];
    }

    @Override
    public long modifyWorldSeed(long seed) {
        return seed ^ this.seedXor;
    }

    @Override
    public boolean isSourceValid(World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        return BiomeTypeConfigHandler.biomeTypeIntersectCheck(this.info.types, biome) && this.info.biome.isValidBiome(biome);
    }

    public void apply(World world, BlockPos center, Random random, int chunkX, int chunkZ, int radiusX, int radiusY, int radiusZ) {
        int centerX = center.func_177958_n();
        int centerY = center.func_177956_o();
        int centerZ = center.func_177952_p();
        double radiusX2 = radiusX * radiusX;
        double radiusY2 = radiusY * radiusY;
        double radiusZ2 = radiusZ * radiusZ;
        UndergroundBiomeGenerationContext context = new UndergroundBiomeGenerationContext();
        this.forEachChunkBlock(chunkX, chunkZ, center.func_177956_o() - radiusY, center.func_177956_o() + radiusY, pos -> {
            int z;
            double distZ;
            int y;
            double distY;
            boolean inside;
            int x = pos.func_177958_n() - center.func_177958_n();
            double distX = x * x;
            boolean bl = inside = distX / radiusX2 + (distY = (double)((y = pos.func_177956_o() - center.func_177956_o()) * y)) / radiusY2 + (distZ = (double)((z = pos.func_177952_p() - center.func_177952_p()) * z)) / radiusZ2 <= 1.0;
            if (inside) {
                this.info.biome.fill(world, center.func_177982_a(x, y, z), context);
            }
        });
        context.floorList.forEach(pos -> this.info.biome.finalFloorPass(world, (BlockPos)pos));
        context.ceilingList.forEach(pos -> this.info.biome.finalCeilingPass(world, (BlockPos)pos));
        context.wallMap.keySet().forEach(pos -> this.info.biome.finalWallPass(world, (BlockPos)pos));
        context.insideList.forEach(pos -> this.info.biome.finalInsidePass(world, (BlockPos)pos));
        if (this.info.biome.hasDungeon() && world instanceof WorldServer && random.nextFloat() < this.info.biome.dungeonChance) {
            BlockPos pos2;
            EnumFacing border;
            ArrayList<BlockPos> candidates = new ArrayList<BlockPos>(context.wallMap.keySet());
            candidates.removeIf(pos -> {
                IBlockState state;
                BlockPos down = pos.func_177977_b();
                return this.info.biome.isWall(world, down, state = world.func_180495_p(down)) || state.func_177230_c().isAir(state, (IBlockAccess)world, down);
            });
            if (!candidates.isEmpty() && (border = context.wallMap.get(pos2 = (BlockPos)candidates.get(world.field_73012_v.nextInt(candidates.size())))) != null) {
                this.info.biome.spawnDungeon((WorldServer)world, pos2, border);
            }
        }
    }

    public static class UndergroundBiomeGenerationContext {
        public List<BlockPos> floorList = new LinkedList<BlockPos>();
        public List<BlockPos> ceilingList = new LinkedList<BlockPos>();
        public List<BlockPos> insideList = new LinkedList<BlockPos>();
        public Map<BlockPos, EnumFacing> wallMap = new HashMap<BlockPos, EnumFacing>();
    }
}

