/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.registry;

import buildcraft.api.registry.IReloadableRegistry;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public interface IScriptableRegistry<E>
extends IReloadableRegistry<E> {
    public String getEntryType();

    public Map<String, Class<? extends E>> getScriptableTypes();

    public Map<String, IEntryDeserializer<? extends E>> getCustomDeserializers();

    default public void addSimpleType(String name, Class<? extends E> type) {
        this.getScriptableTypes().put(name, type);
    }

    default public void addCustomType(String name, IEntryDeserializer<? extends E> deserializer) {
        this.getCustomDeserializers().put(name, deserializer);
    }

    public static final class OptionallyDisabled<E> {
        @Nullable
        private final E object;
        @Nullable
        private final String reason;

        public OptionallyDisabled(E object) {
            this.object = object;
            this.reason = null;
        }

        public OptionallyDisabled(String reason) {
            this.object = null;
            this.reason = reason;
        }

        public boolean isPresent() {
            return this.object != null;
        }

        @Nonnull
        public E get() {
            E o = this.object;
            if (o != null) {
                return o;
            }
            throw new IllegalStateException("This object has been disabled! You must call isPresent() first!");
        }

        @Nonnull
        public String getDisabledReason() {
            String r = this.reason;
            if (r != null) {
                return r;
            }
            throw new IllegalStateException("This object has not been disabled! You must call isPresent() first!");
        }
    }

    @FunctionalInterface
    public static interface ISimpleEntryDeserializer<E>
    extends IEntryDeserializer<E> {
        @Override
        default public OptionallyDisabled<E> deserialize(ResourceLocation name, JsonObject obj, JsonDeserializationContext ctx) throws JsonSyntaxException {
            return new OptionallyDisabled<E>(this.deserializeConst(name, obj, ctx));
        }

        public E deserializeConst(ResourceLocation var1, JsonObject var2, JsonDeserializationContext var3) throws JsonSyntaxException;
    }

    @FunctionalInterface
    public static interface IEntryDeserializer<E> {
        public OptionallyDisabled<E> deserialize(ResourceLocation var1, JsonObject var2, JsonDeserializationContext var3) throws JsonSyntaxException;
    }
}

