/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;

public abstract class PipeFlow
implements ICapabilityProvider {
    public static final int NET_ID_FULL_STATE = 0;
    public static final int NET_ID_UPDATE = 1;
    public final IPipe pipe;

    public PipeFlow(IPipe pipe) {
        this.pipe = pipe;
    }

    public PipeFlow(IPipe pipe, NBTTagCompound nbt) {
        this.pipe = pipe;
    }

    public NBTTagCompound writeToNbt() {
        return new NBTTagCompound();
    }

    public void writePayload(int id, PacketBuffer buffer, Side side) {
    }

    public void readPayload(int id, PacketBuffer buffer, Side side) throws IOException {
    }

    public void sendPayload(int id) {
        Side side = this.pipe.getHolder().getPipeWorld().field_72995_K ? Side.CLIENT : Side.SERVER;
        this.sendCustomPayload(id, buf -> this.writePayload(id, buf, side));
    }

    public final void sendCustomPayload(int id, IPipeHolder.IWriter writer) {
        this.pipe.getHolder().sendMessage(IPipeHolder.PipeMessageReceiver.FLOW, buffer -> {
            buffer.writeBoolean(true);
            buffer.writeShort(id);
            writer.write(buffer);
        });
    }

    public abstract boolean canConnect(EnumFacing var1, PipeFlow var2);

    public abstract boolean canConnect(EnumFacing var1, TileEntity var2);

    public void onTick() {
    }

    public void addDrops(NonNullList<ItemStack> toDrop, int fortune) {
    }

    public boolean onFlowActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        return false;
    }

    public final boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        return null;
    }
}

