/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.module.jei;

import buildcraft.api.BCModules;
import buildcraft.api.core.BCLog;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.IRefineryRecipeManager;
import buildcraft.compat.module.jei.energy.combustionengine.CategoryCombustionEngine;
import buildcraft.compat.module.jei.energy.combustionengine.HandlerCombustionEngine;
import buildcraft.compat.module.jei.factory.CategoryCoolable;
import buildcraft.compat.module.jei.factory.CategoryDistiller;
import buildcraft.compat.module.jei.factory.CategoryHeatable;
import buildcraft.compat.module.jei.factory.HandlerCoolable;
import buildcraft.compat.module.jei.factory.HandlerDistiller;
import buildcraft.compat.module.jei.factory.HandlerHeatable;
import buildcraft.compat.module.jei.recipe.GuiHandlerBuildCraft;
import buildcraft.compat.module.jei.transferhandlers.AdvancedCraftingItemsTransferHandler;
import buildcraft.compat.module.jei.transferhandlers.AutoCraftItemsTransferHandler;
import buildcraft.lib.fluid.FuelRegistry;
import buildcraft.silicon.container.ContainerAssemblyTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraftforge.fml.common.Loader;

@JEIPlugin
public class BCPluginJEI
implements IModPlugin {
    public static IModRegistry registry;

    public void register(IModRegistry registry) {
        BCPluginJEI.registry = registry;
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new GuiHandlerBuildCraft()});
        boolean factory = BCModules.FACTORY.isLoaded();
        boolean energy = BCModules.ENERGY.isLoaded();
        boolean silicon = BCModules.SILICON.isLoaded();
        if (factory) {
            registry.handleRecipes(IRefineryRecipeManager.ICoolableRecipe.class, (IRecipeWrapperFactory)new HandlerCoolable(), "buildcraft:category_coolable");
            registry.handleRecipes(IRefineryRecipeManager.IDistillationRecipe.class, (IRecipeWrapperFactory)new HandlerDistiller(), "buildcraft:category_distiller");
            registry.handleRecipes(IRefineryRecipeManager.IHeatableRecipe.class, (IRecipeWrapperFactory)new HandlerHeatable(), "buildcraft:category_heatable");
            registry.addRecipes((Collection)ImmutableList.copyOf(BuildcraftRecipeRegistry.refineryRecipes.getCoolableRegistry().getAllRecipes()), "buildcraft:category_coolable");
            registry.addRecipes((Collection)ImmutableList.copyOf(BuildcraftRecipeRegistry.refineryRecipes.getDistillationRegistry().getAllRecipes()), "buildcraft:category_distiller");
            registry.addRecipes((Collection)ImmutableList.copyOf(BuildcraftRecipeRegistry.refineryRecipes.getHeatableRegistry().getAllRecipes()), "buildcraft:category_heatable");
        }
        if (energy) {
            registry.handleRecipes(IFuel.class, (IRecipeWrapperFactory)new HandlerCombustionEngine(), "buildcraft-compat:engine.combustion");
            registry.addRecipes((Collection)ImmutableList.copyOf(FuelRegistry.INSTANCE.getFuels()), "buildcraft-compat:engine.combustion");
        }
        if (silicon) {
            // empty if block
        }
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new AutoCraftItemsTransferHandler(), "minecraft.crafting");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferHandler)new AdvancedCraftingItemsTransferHandler(), "minecraft.crafting");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerAssemblyTable.class, "buildcraft-compat:silicon.assembly", 36, 12, 0, 36);
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        boolean factory = Loader.isModLoaded((String)BCModules.FACTORY.getModId());
        boolean energy = Loader.isModLoaded((String)BCModules.ENERGY.getModId());
        boolean silicon = Loader.isModLoaded((String)BCModules.SILICON.getModId());
        ArrayList lst = Lists.newArrayList();
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        if (factory) {
            lst.add("factory");
            registry.addRecipeCategories(new IRecipeCategory[]{new CategoryHeatable(helper)});
            registry.addRecipeCategories(new IRecipeCategory[]{new CategoryDistiller(helper)});
            registry.addRecipeCategories(new IRecipeCategory[]{new CategoryCoolable(helper)});
        }
        if (energy) {
            lst.add("energy");
            registry.addRecipeCategories(new IRecipeCategory[]{new CategoryCombustionEngine(helper)});
        }
        if (silicon) {
            lst.add("silicon");
        }
        BCLog.logger.info("Loaded JEI mods: " + Arrays.toString(lst.toArray()));
    }
}

