/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.block;

import buildcraft.api.blocks.CustomRotationHelper;
import buildcraft.api.blocks.ICustomRotationHandler;
import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.misc.collect.OrderedEnumMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndRod;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGlazedTerracotta;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class VanillaRotationHandlers {
    public static final OrderedEnumMap<EnumFacing> ROTATE_HORIZONTAL;
    public static final OrderedEnumMap<EnumFacing> ROTATE_FACING;
    public static final OrderedEnumMap<EnumFacing> ROTATE_TORCH;
    public static final OrderedEnumMap<EnumFacing> ROTATE_HOPPER;
    public static final OrderedEnumMap<BlockLever.EnumOrientation> ROTATE_LEVER;

    public static void fmlInit() {
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockButton.class, VanillaRotationHandlers::rotateButton);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockTripWireHook.class, VanillaRotationHandlers::rotateTripWireHook);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockDoor.class, VanillaRotationHandlers::rotateDoor);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockPistonBase.class, VanillaRotationHandlers::rotatePiston);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockLever.class, VanillaRotationHandlers::rotateLever);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockShulkerBox.class, VanillaRotationHandlers::rotateShulkerBox);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockDispenser.class, VanillaRotationHandlers.getHandlerFreely(BlockDispenser.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockObserver.class, VanillaRotationHandlers.getHandlerFreely(BlockObserver.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockEndRod.class, VanillaRotationHandlers.getHandlerFreely(BlockEndRod.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockFenceGate.class, VanillaRotationHandlers.getHandlerHorizontalFreely(BlockFenceGate.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockRedstoneDiode.class, VanillaRotationHandlers.getHandlerHorizontalFreely(BlockRedstoneDiode.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockPumpkin.class, VanillaRotationHandlers.getHandlerHorizontalFreely(BlockPumpkin.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockGlazedTerracotta.class, VanillaRotationHandlers.getHandlerHorizontalFreely(BlockGlazedTerracotta.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockAnvil.class, VanillaRotationHandlers.getHandlerHorizontalFreely(BlockAnvil.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockEnderChest.class, VanillaRotationHandlers.getHandlerHorizontalFreely(BlockEnderChest.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockFurnace.class, VanillaRotationHandlers.getHandlerHorizontalFreely(BlockFurnace.class));
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockCocoa.class, VanillaRotationHandlers::rotateCocoa);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockTorch.class, VanillaRotationHandlers::rotateTorch);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockLadder.class, VanillaRotationHandlers::rotateLadder);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockHopper.class, VanillaRotationHandlers::rotateHopper);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockChest.class, VanillaRotationHandlers::rotateChest);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockTrapDoor.class, VanillaRotationHandlers::rotateTrapDoor);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockStairs.class, VanillaRotationHandlers::rotateStairs);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockSkull.class, VanillaRotationHandlers::rotateSkull);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockBanner.BlockBannerHanging.class, VanillaRotationHandlers::rotateHangingBanner);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockWallSign.class, VanillaRotationHandlers::rotateWallSign);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockBanner.BlockBannerStanding.class, VanillaRotationHandlers::rotateStandingBanner);
        CustomRotationHelper.INSTANCE.registerHandlerForAll(BlockStandingSign.class, VanillaRotationHandlers::rotateStandingSign);
    }

    public static <T> int getOrdinal(T side, T[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (side != array[i]) continue;
            return i;
        }
        return 0;
    }

    private static EnumActionResult rotateDoor(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockDoor) {
            IBlockState lowerState;
            BlockPos lowerPos;
            IBlockState upperState;
            BlockPos upperPos;
            if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER) {
                upperPos = pos;
                upperState = state;
                lowerPos = upperPos.func_177977_b();
                lowerState = world.func_180495_p(lowerPos);
                if (!(lowerState.func_177230_c() instanceof BlockDoor)) {
                    return EnumActionResult.PASS;
                }
            } else {
                lowerPos = pos;
                lowerState = state;
                upperPos = lowerPos.func_177984_a();
                upperState = world.func_180495_p(upperPos);
                if (!(upperState.func_177230_c() instanceof BlockDoor)) {
                    return EnumActionResult.PASS;
                }
            }
            if (lowerState.func_177229_b((IProperty)BlockDoor.field_176520_a) == ROTATE_HORIZONTAL.get(0)) {
                BlockDoor.EnumHingePosition hinge = (BlockDoor.EnumHingePosition)upperState.func_177229_b((IProperty)BlockDoor.field_176521_M);
                hinge = hinge == BlockDoor.EnumHingePosition.LEFT ? BlockDoor.EnumHingePosition.RIGHT : BlockDoor.EnumHingePosition.LEFT;
                world.func_175656_a(upperPos, upperState.func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)hinge));
            }
            return VanillaRotationHandlers.rotateOnce(world, lowerPos, lowerState, BlockTrapDoor.field_176284_a, ROTATE_HORIZONTAL);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateButton(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockButton) {
            return VanillaRotationHandlers.rotateEnumFacing(world, pos, state, (IProperty<EnumFacing>)BlockButton.field_176387_N, ROTATE_FACING);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateTripWireHook(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockTripWireHook) {
            return VanillaRotationHandlers.rotateEnumFacing(world, pos, state, (IProperty<EnumFacing>)BlockTripWireHook.field_176264_a, ROTATE_HORIZONTAL);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotatePiston(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockPistonBase) {
            boolean extended = (Boolean)state.func_177229_b((IProperty)BlockPistonBase.field_176320_b);
            if (extended) {
                return EnumActionResult.FAIL;
            }
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockDirectional.field_176387_N, ROTATE_FACING);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateLever(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockLever) {
            return VanillaRotationHandlers.rotateAnyTypeAuto(world, pos, state, BlockLever.field_176360_a, ROTATE_LEVER, BlockLever.EnumOrientation::func_176852_c);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateHopper(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockHopper) {
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockHopper.field_176430_a, ROTATE_HOPPER);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateShulkerBox(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockShulkerBox) {
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockShulkerBox.field_190957_a, ROTATE_FACING);
        }
        return EnumActionResult.PASS;
    }

    private static ICustomRotationHandler getHandlerFreely(Class<? extends Block> blockClass) {
        return (world, pos, state, sideWrenched) -> VanillaRotationHandlers.rotateFreely(world, pos, state, sideWrenched, blockClass);
    }

    private static EnumActionResult rotateFreely(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched, Class<? extends Block> blockClass) {
        if (blockClass.isInstance(state.func_177230_c())) {
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockDirectional.field_176387_N, ROTATE_FACING);
        }
        return EnumActionResult.PASS;
    }

    private static ICustomRotationHandler getHandlerHorizontalFreely(Class<? extends Block> blockClass) {
        return (world, pos, state, sideWrenched) -> VanillaRotationHandlers.rotateHorizontalFreely(world, pos, state, sideWrenched, blockClass);
    }

    private static EnumActionResult rotateHorizontalFreely(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched, Class<? extends Block> blockClass) {
        if (blockClass.isInstance(state.func_177230_c())) {
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockHorizontal.field_185512_D, ROTATE_HORIZONTAL);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateCocoa(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockCocoa) {
            return VanillaRotationHandlers.rotateAnyTypeManual(world, pos, state, BlockCocoa.field_185512_D, ROTATE_HORIZONTAL, toTry -> ((BlockCocoa)state.func_177230_c()).func_176499_e(world, pos, state.func_177226_a((IProperty)BlockCocoa.field_185512_D, (Comparable)toTry)));
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateLadder(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockLadder) {
            Predicate<EnumFacing> tester = toTry -> {
                BlockPos offsetPos = pos.func_177972_a(toTry.func_176734_d());
                IBlockState offsetState = world.func_180495_p(offsetPos);
                return !offsetState.func_185897_m() && offsetState.func_193401_d((IBlockAccess)world, offsetPos, toTry) == BlockFaceShape.SOLID && !BlockBCBase_Neptune.isExceptBlockForAttachWithPiston(offsetState.func_177230_c());
            };
            return VanillaRotationHandlers.rotateAnyTypeManual(world, pos, state, BlockLadder.field_176382_a, ROTATE_HORIZONTAL, tester);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateTorch(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockTorch) {
            Predicate<EnumFacing> tester = toTry -> {
                BlockPos offsetPos = pos.func_177972_a(toTry.func_176734_d());
                IBlockState offsetState = world.func_180495_p(offsetPos);
                if (toTry == EnumFacing.UP && offsetState.func_177230_c().canPlaceTorchOnTop(state, (IBlockAccess)world, offsetPos)) {
                    return true;
                }
                if (toTry != EnumFacing.UP && toTry != EnumFacing.DOWN) {
                    return offsetState.func_193401_d((IBlockAccess)world, offsetPos, toTry) == BlockFaceShape.SOLID && !BlockBCBase_Neptune.isExceptBlockForAttachWithPiston(offsetState.func_177230_c());
                }
                return false;
            };
            return VanillaRotationHandlers.rotateAnyTypeManual(world, pos, state, BlockTorch.field_176596_a, ROTATE_TORCH, tester);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateChest(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockChest) {
            BlockPos otherPos = null;
            for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                BlockPos candidate = pos.func_177972_a(facing);
                if (world.func_180495_p(candidate).func_177230_c() != state.func_177230_c()) continue;
                otherPos = candidate;
                break;
            }
            if (otherPos != null) {
                EnumFacing facing;
                IBlockState otherState = world.func_180495_p(otherPos);
                facing = (EnumFacing)state.func_177229_b((IProperty)BlockChest.field_176459_a);
                if (otherState.func_177229_b((IProperty)BlockChest.field_176459_a) == facing) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing.func_176734_d()));
                    world.func_175656_a(otherPos, otherState.func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing.func_176734_d()));
                    return EnumActionResult.SUCCESS;
                }
            }
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockChest.field_176459_a, ROTATE_HORIZONTAL);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateTrapDoor(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockTrapDoor) {
            if (state.func_177229_b((IProperty)BlockTrapDoor.field_176284_a) == ROTATE_HORIZONTAL.get(0)) {
                BlockTrapDoor.DoorHalf half = (BlockTrapDoor.DoorHalf)state.func_177229_b((IProperty)BlockTrapDoor.field_176285_M);
                half = half == BlockTrapDoor.DoorHalf.TOP ? BlockTrapDoor.DoorHalf.BOTTOM : BlockTrapDoor.DoorHalf.TOP;
                state = state.func_177226_a((IProperty)BlockTrapDoor.field_176285_M, (Comparable)half);
            }
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockTrapDoor.field_176284_a, ROTATE_HORIZONTAL);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateStairs(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockStairs) {
            if (state.func_177229_b((IProperty)BlockStairs.field_176309_a) == ROTATE_HORIZONTAL.get(0)) {
                BlockStairs.EnumHalf half = (BlockStairs.EnumHalf)state.func_177229_b((IProperty)BlockStairs.field_176308_b);
                half = half == BlockStairs.EnumHalf.TOP ? BlockStairs.EnumHalf.BOTTOM : BlockStairs.EnumHalf.TOP;
                state = state.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)half);
            }
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockStairs.field_176309_a, ROTATE_HORIZONTAL);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateSkull(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockSkull) {
            if (((EnumFacing)state.func_177229_b((IProperty)BlockSkull.field_176418_a)).func_176740_k().func_176720_b()) {
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntitySkull) {
                    TileEntitySkull tileSkull = (TileEntitySkull)tile;
                    int rot = (Integer)ObfuscationReflectionHelper.getPrivateValue(TileEntitySkull.class, (Object)tileSkull, (String[])new String[]{"skullRotation", "field_145910_i"});
                    rot = (rot + 1) % 16;
                    tileSkull.func_145903_a(rot);
                    tileSkull.func_70296_d();
                    world.func_184138_a(pos, state, state, 3);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }
            return VanillaRotationHandlers.rotateOnce(world, pos, state, BlockSkull.field_176418_a, ROTATE_HORIZONTAL);
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateHangingBanner(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockBanner.BlockBannerHanging) {
            return VanillaRotationHandlers.rotateAnyTypeManual(world, pos, state, BlockBanner.field_176449_a, ROTATE_HORIZONTAL, toTry -> world.func_180495_p(pos.func_177972_a(toTry.func_176734_d())).func_185904_a().func_76220_a());
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateWallSign(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockWallSign) {
            return VanillaRotationHandlers.rotateAnyTypeManual(world, pos, state, BlockWallSign.field_176412_a, ROTATE_HORIZONTAL, toTry -> world.func_180495_p(pos.func_177972_a(toTry.func_176734_d())).func_185904_a().func_76220_a());
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateStandingBanner(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockBanner.BlockBannerStanding) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockBanner.field_176448_b, (Comparable)Integer.valueOf(((Integer)state.func_177229_b((IProperty)BlockBanner.field_176448_b) + 1) % 16)));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private static EnumActionResult rotateStandingSign(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        if (state.func_177230_c() instanceof BlockStandingSign) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockStandingSign.field_176413_a, (Comparable)Integer.valueOf(((Integer)state.func_177229_b((IProperty)BlockStandingSign.field_176413_a) + 1) % 16)));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static EnumActionResult rotateEnumFacing(World world, BlockPos pos, IBlockState state, IProperty<EnumFacing> prop, OrderedEnumMap<EnumFacing> possible) {
        return VanillaRotationHandlers.rotateAnyTypeAuto(world, pos, state, prop, possible, f -> f);
    }

    public static <E extends Enum<E>> EnumActionResult rotateOnce(World world, BlockPos pos, IBlockState state, IProperty<E> prop, OrderedEnumMap<E> possible) {
        Enum current = (Enum)((Object)state.func_177229_b(prop));
        current = possible.next(current);
        world.func_175656_a(pos, state.func_177226_a(prop, (Comparable)((Object)current)));
        return EnumActionResult.SUCCESS;
    }

    public static <E extends Enum<E>> EnumActionResult rotateAnyTypeAuto(World world, BlockPos pos, IBlockState state, IProperty<E> prop, OrderedEnumMap<E> possible, Function<E, EnumFacing> mapper) {
        Predicate<Enum> tester = toTry -> state.func_177230_c().func_176198_a(world, pos, (EnumFacing)mapper.apply(toTry));
        return VanillaRotationHandlers.rotateAnyTypeManual(world, pos, state, prop, possible, tester);
    }

    public static <E extends Enum<E>> EnumActionResult rotateAnyTypeManual(World world, BlockPos pos, IBlockState state, IProperty<E> prop, OrderedEnumMap<E> possible, Predicate<E> canPlace) {
        Enum current = (Enum)((Object)state.func_177229_b(prop));
        for (int i = possible.getOrderLength(); i > 1; --i) {
            if (!canPlace.test(current = possible.next(current))) continue;
            world.func_175656_a(pos, state.func_177226_a(prop, (Comparable)((Object)current)));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    static {
        EnumFacing e = EnumFacing.EAST;
        EnumFacing w = EnumFacing.WEST;
        EnumFacing u = EnumFacing.UP;
        EnumFacing d = EnumFacing.DOWN;
        EnumFacing n = EnumFacing.NORTH;
        EnumFacing s = EnumFacing.SOUTH;
        ROTATE_HORIZONTAL = new OrderedEnumMap(EnumFacing.class, (Enum[])new EnumFacing[]{e, s, w, n});
        ROTATE_FACING = new OrderedEnumMap(EnumFacing.class, (Enum[])new EnumFacing[]{e, s, d, w, n, u});
        ROTATE_TORCH = new OrderedEnumMap(EnumFacing.class, (Enum[])new EnumFacing[]{e, s, w, n, u});
        ROTATE_HOPPER = new OrderedEnumMap(EnumFacing.class, (Enum[])new EnumFacing[]{e, s, w, n, d});
        BlockLever.EnumOrientation[] leverFaces = new BlockLever.EnumOrientation[8];
        int index = 0;
        for (EnumFacing face : (EnumFacing[])ROTATE_FACING.getOrder()) {
            if (face == EnumFacing.DOWN) {
                leverFaces[index++] = BlockLever.EnumOrientation.DOWN_Z;
                leverFaces[index++] = BlockLever.EnumOrientation.DOWN_X;
                continue;
            }
            if (face == EnumFacing.UP) {
                leverFaces[index++] = BlockLever.EnumOrientation.UP_Z;
                leverFaces[index++] = BlockLever.EnumOrientation.UP_X;
                continue;
            }
            leverFaces[index++] = BlockLever.EnumOrientation.func_176856_a((EnumFacing)face, null);
        }
        ROTATE_LEVER = new OrderedEnumMap(BlockLever.EnumOrientation.class, (Enum[])leverFaces);
    }
}

