/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.cache;

import buildcraft.lib.cache.ITileCache;
import buildcraft.lib.cache.TileCacheRet;
import buildcraft.lib.misc.ChunkUtil;
import buildcraft.lib.misc.PositionUtil;
import buildcraft.lib.misc.data.FaceDistance;
import buildcraft.lib.tile.TileBC_Neptune;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;

public class NeighbourTileCache
implements ITileCache {
    private final TileEntity tile;
    private BlockPos lastSeenTilePos;
    private final Map<EnumFacing, WeakReference<TileEntity>> cachedTiles = new EnumMap<EnumFacing, WeakReference<TileEntity>>(EnumFacing.class);

    public NeighbourTileCache(TileEntity tile) {
        this.tile = tile;
    }

    @Override
    public void invalidate() {
        this.cachedTiles.clear();
    }

    @Override
    public TileCacheRet getTile(BlockPos pos) {
        if (!this.canUseCache()) {
            return null;
        }
        FaceDistance offset = PositionUtil.getDirectOffset(this.lastSeenTilePos, pos);
        if (offset == null || offset.distance != 1) {
            return null;
        }
        return this.getTile0(offset.direction);
    }

    private boolean canUseCache() {
        if (this.tile.func_145837_r()) {
            return false;
        }
        BlockPos tPos = this.tile.func_174877_v();
        if (!tPos.equals((Object)this.lastSeenTilePos)) {
            this.lastSeenTilePos = tPos.func_185334_h();
            this.cachedTiles.clear();
        }
        return true;
    }

    @Override
    public TileCacheRet getTile(EnumFacing offset) {
        if (!this.canUseCache()) {
            return null;
        }
        return this.getTile0(offset);
    }

    private TileCacheRet getTile0(EnumFacing offset) {
        BlockPos offsetPos;
        Chunk chunk;
        TileEntity offsetTile;
        WeakReference<TileEntity> ref = this.cachedTiles.get(offset);
        if (ref != null) {
            TileEntity oTile = (TileEntity)ref.get();
            if (oTile == null || oTile.func_145837_r()) {
                this.cachedTiles.remove(offset);
            } else {
                return new TileCacheRet(oTile);
            }
        }
        if ((offsetTile = (chunk = this.tile instanceof TileBC_Neptune ? ((TileBC_Neptune)this.tile).getChunk(offsetPos) : ChunkUtil.getChunk(this.tile.func_145831_w(), offsetPos, true)).func_177424_a(offsetPos = this.lastSeenTilePos.func_177972_a(offset), Chunk.EnumCreateEntityType.IMMEDIATE)) != null) {
            this.cachedTiles.put(offset, new WeakReference<TileEntity>(offsetTile));
        }
        return new TileCacheRet(offsetTile);
    }
}

