/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.api.registry.EventBuildCraftReload;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuidePageRegistry;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.TypeOrder;
import buildcraft.lib.client.guide.data.JsonTypeTags;
import buildcraft.lib.client.guide.entry.IEntryLinkConsumer;
import buildcraft.lib.client.guide.entry.ItemStackValueFilter;
import buildcraft.lib.client.guide.entry.PageEntry;
import buildcraft.lib.client.guide.entry.PageValueType;
import buildcraft.lib.client.guide.loader.IPageLoader;
import buildcraft.lib.client.guide.loader.MarkdownPageLoader;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePageStandInRecipes;
import buildcraft.lib.client.guide.parts.contents.ContentsNode;
import buildcraft.lib.client.guide.parts.contents.ContentsNodeGui;
import buildcraft.lib.client.guide.parts.contents.GuidePageContents;
import buildcraft.lib.client.guide.parts.contents.IContentsNode;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.client.guide.parts.contents.PageLinkNormal;
import buildcraft.lib.client.guide.ref.GuideGroupManager;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.guide.GuideBook;
import buildcraft.lib.guide.GuideBookRegistry;
import buildcraft.lib.guide.GuideContentsData;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.misc.LocaleUtil;
import com.google.common.base.Stopwatch;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.Language;
import net.minecraft.client.util.SuffixArray;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public enum GuideManager implements IResourceManagerReloadListener
{
    INSTANCE;

    public static final String DEFAULT_LANG = "en_us";
    public static final Map<String, IPageLoader> PAGE_LOADERS;
    public static final GuideContentsData BOOK_ALL_DATA;
    private final List<PageEntry<?>> entries = new ArrayList();
    private final Map<ResourceLocation, GuidePageFactory> pages = new HashMap<ResourceLocation, GuidePageFactory>();
    private final Map<ItemStack, GuidePageFactory> generatedPages = new HashMap<ItemStack, GuidePageFactory>();
    public static final boolean DEBUG;
    public SuffixArray<PageLink> quickSearcher;
    private final Map<GuideBook, Map<TypeOrder, ContentsNode>> contents = new HashMap<GuideBook, Map<TypeOrder, ContentsNode>>();
    public final Set<Object> objectsAdded = new HashSet<Object>();
    private boolean isInReload = false;

    public void onRegistryReload(EventBuildCraftReload.FinishLoad event) {
        if (this.isInReload) {
            return;
        }
        if (event.reloadingRegistries.contains(GuideBookRegistry.INSTANCE)) {
            this.reload();
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.reload(resourceManager);
    }

    public void reload() {
        this.reload(Minecraft.func_71410_x().func_110442_L());
    }

    private void reload(IResourceManager resourceManager) {
        if (this.isInReload) {
            throw new IllegalStateException("Cannot reload while we are reloading!");
        }
        try {
            this.isInReload = true;
            this.reload0(resourceManager);
        }
        finally {
            this.isInReload = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reload0(IResourceManager resourceManager) {
        void var6_13;
        GuideGroupManager.get("lols", "hi");
        Stopwatch watch = Stopwatch.createStarted();
        GuideBookRegistry.INSTANCE.reload();
        GuidePageRegistry.INSTANCE.reload();
        this.entries.clear();
        GuidePageRegistry manager = GuidePageRegistry.INSTANCE;
        HashMap domains = new HashMap();
        domains.put(null, new HashSet());
        for (GuideBook guideBook : GuideBookRegistry.INSTANCE.getAllEntries()) {
            domains.put(guideBook, new HashSet());
        }
        for (PageEntry pageEntry : manager.getAllEntries()) {
            ((Set)domains.get(null)).add(pageEntry.typeTags.domain);
            GuideBook book = GuideBookRegistry.INSTANCE.getBook(pageEntry.book.toString());
            Set domainSet = (Set)domains.get(book);
            if (domainSet != null && book != null) {
                domainSet.add(pageEntry.typeTags.domain);
            }
            this.entries.add(pageEntry);
        }
        BOOK_ALL_DATA.generate((Set)domains.get(null));
        for (Map.Entry entry : domains.entrySet()) {
            if (entry.getKey() == null) continue;
            ((GuideBook)entry.getKey()).data.generate((Set)entry.getValue());
        }
        this.pages.clear();
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (currentLanguage == null) {
            BCLog.logger.warn("Current language was null!");
            String string = DEFAULT_LANG;
        } else {
            String string = currentLanguage.func_135034_a();
        }
        this.loadLangInternal(resourceManager, DEFAULT_LANG);
        if (!DEFAULT_LANG.equals(var6_13)) {
            this.loadLangInternal(resourceManager, (String)var6_13);
        }
        this.generateContentsPage();
        watch.stop();
        long time = watch.elapsed(TimeUnit.MILLISECONDS);
        int p = this.entries.size();
        int a = this.pages.size();
        int e = p - a;
        BCLog.logger.info("[lib.guide] Loaded " + p + " possible and " + a + " actual guide pages (" + e + " not found) in " + time + "ms.");
    }

    private void loadLangInternal(IResourceManager resourceManager, String lang) {
        block12: for (Map.Entry mapEntry : GuidePageRegistry.INSTANCE.getReloadableEntryMap().entrySet()) {
            ResourceLocation entryKey = mapEntry.getKey();
            String domain = entryKey.func_110624_b();
            String path = "compat/buildcraft/guide/" + lang + "/" + entryKey.func_110623_a();
            for (Map.Entry<String, IPageLoader> entry : PAGE_LOADERS.entrySet()) {
                ResourceLocation fLoc = new ResourceLocation(domain, path + "." + entry.getKey());
                try {
                    InputStream stream = resourceManager.func_110536_a(fLoc).func_110527_b();
                    Throwable throwable = null;
                    try {
                        GuidePageFactory factory = entry.getValue().loadPage(stream, entryKey, (PageEntry)mapEntry.getValue());
                        this.pages.put(entryKey, factory);
                        if (!DEBUG) continue block12;
                        BCLog.logger.info("[lib.guide.loader] Loaded page '" + entryKey + "'.");
                        continue block12;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue block12;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue block12;
                        }
                        stream.close();
                        continue block12;
                    }
                }
                catch (FileNotFoundException stream) {
                }
                catch (IOException io) {
                    io.printStackTrace();
                }
            }
            if (this.pages.containsKey(entryKey)) continue;
            String endings = PAGE_LOADERS.size() == 1 ? PAGE_LOADERS.keySet().iterator().next() : PAGE_LOADERS.keySet().toString();
            BCLog.logger.warn("[lib.guide.loader] Unable to load guide page '" + entryKey + "' (full path = '" + domain + ":" + path + "." + endings + "') because we couldn't find any of the valid paths in any resource pack!");
        }
    }

    private void generateContentsPage() {
        this.objectsAdded.clear();
        this.contents.clear();
        this.genTypeMap(null);
        for (GuideBook guideBook : GuideBookRegistry.INSTANCE.getAllEntries()) {
            this.genTypeMap(guideBook);
        }
        this.quickSearcher = new SuffixArray();
        for (Map.Entry entry : GuidePageRegistry.INSTANCE.getReloadableEntryMap().entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            GuidePageFactory entryFactory = INSTANCE.getFactoryFor(resourceLocation);
            PageEntry entry2 = (PageEntry)entry.getValue();
            String translatedTitle = entry2.title;
            ISimpleDrawable icon = entry2.createDrawable();
            PageLine line = new PageLine(icon, icon, 2, translatedTitle, true);
            if (entryFactory == null) continue;
            this.objectsAdded.add(entry2.getBasicValue());
            PageLinkNormal pageLink = new PageLinkNormal(line, true, entry2.getTooltip(), entryFactory);
            this.addChild(entry2.book, entry2.typeTags, pageLink);
        }
        IEntryLinkConsumer adder = (tags, page) -> this.addChild(null, tags, page);
        for (PageValueType<?> pageValueType : GuidePageRegistry.INSTANCE.types) {
            pageValueType.iterateAllDefault(adder);
        }
        this.quickSearcher.func_194058_a();
        for (Map<TypeOrder, ContentsNode> map : this.contents.values()) {
            for (ContentsNode node : map.values()) {
                node.sort();
            }
        }
    }

    private void genTypeMap(GuideBook book) {
        HashMap<TypeOrder, ContentsNode> map = new HashMap<TypeOrder, ContentsNode>();
        this.contents.put(book, map);
        for (TypeOrder order : GuiGuide.SORTING_TYPES) {
            map.put(order, new ContentsNode("root", -1));
        }
    }

    private void addChild(ResourceLocation bookType, JsonTypeTags tags, PageLink page) {
        for (Map.Entry<GuideBook, Map<TypeOrder, ContentsNode>> bookEntry : this.contents.entrySet()) {
            GuideBook book = bookEntry.getKey();
            if (bookType == null ? book != null && !book.appendAllEntries : book != null && !book.name.equals((Object)bookType)) continue;
            Map<TypeOrder, ContentsNode> map = bookEntry.getValue();
            for (Map.Entry<TypeOrder, ContentsNode> entry : map.entrySet()) {
                TypeOrder order = entry.getKey();
                ContentsNode node = entry.getValue();
                String[] ordered = tags.getOrdered(order);
                for (int i = 0; i < ordered.length; ++i) {
                    String title = LocaleUtil.localize(ordered[i]);
                    IContentsNode subNode = node.getChild(title);
                    if (subNode instanceof ContentsNode) {
                        node = (ContentsNode)subNode;
                        continue;
                    }
                    if (subNode == null) {
                        ContentsNode subContents = new ContentsNode(title, i);
                        node.addChild(subContents);
                        node = subContents;
                        continue;
                    }
                    throw new IllegalStateException("Unknown node type " + subNode.getClass());
                }
                node.addChild(page);
                this.quickSearcher.func_194057_a((Object)page, page.getSearchName());
            }
        }
    }

    @Nullable
    public GuidePageFactory getFactoryFor(ResourceLocation partialLocation) {
        return this.pages.get(partialLocation);
    }

    @Nullable
    public GuidePageFactory getFactoryFor(Object value) {
        if (value instanceof ItemStackValueFilter) {
            value = ((ItemStackValueFilter)value).stack.baseStack;
        } else if (value instanceof ItemStackKey) {
            value = ((ItemStackKey)value).baseStack;
        }
        if (value instanceof ItemStack) {
            return this.getPageFor((ItemStack)value);
        }
        return this.getFactoryFor(GuideManager.getEntryFor(value));
    }

    public static ResourceLocation getEntryFor(Object obj) {
        for (Map.Entry entry : GuidePageRegistry.INSTANCE.getReloadableEntryMap().entrySet()) {
            if (!((PageEntry)entry.getValue()).matches(obj)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Nonnull
    public GuidePageFactory getPageFor(@Nonnull ItemStack stack) {
        GuidePageFactory factory;
        ResourceLocation entry = GuideManager.getEntryFor(stack);
        if (entry != null && (factory = this.getFactoryFor(entry)) != null) {
            return factory;
        }
        return this.generatedPages.computeIfAbsent(stack, GuidePageStandInRecipes::createFactory);
    }

    public ContentsNodeGui getGuiContents(GuiGuide gui, GuidePageContents guidePageContents, TypeOrder sortingOrder) {
        Map<TypeOrder, ContentsNode> map = this.contents.get(gui.book);
        if (map == null) {
            throw new IllegalStateException("Unknown book " + gui.book);
        }
        ContentsNode node = map.get(sortingOrder);
        if (node == null) {
            throw new IllegalStateException("Unknown sorting order " + sortingOrder);
        }
        node.resetVisibility();
        return new ContentsNodeGui(gui, guidePageContents, node);
    }

    static {
        PAGE_LOADERS = new HashMap<String, IPageLoader>();
        BOOK_ALL_DATA = new GuideContentsData(null);
        DEBUG = BCDebugging.shouldDebugLog("lib.guide.loader");
        PAGE_LOADERS.put("md", MarkdownPageLoader.INSTANCE);
    }
}

