/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.entry;

import buildcraft.api.registry.IScriptableRegistry;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.guide.data.JsonTypeTags;
import buildcraft.lib.client.guide.entry.IEntryLinkConsumer;
import buildcraft.lib.client.guide.entry.ItemStackValueFilter;
import buildcraft.lib.client.guide.entry.PageEntry;
import buildcraft.lib.client.guide.entry.PageValueType;
import buildcraft.lib.client.guide.loader.MarkdownPageLoader;
import buildcraft.lib.client.guide.loader.XmlPageLoader;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.contents.PageLinkItemStack;
import buildcraft.lib.gui.GuiStack;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.misc.GuiUtil;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.registry.RegistryConfig;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class PageEntryItemStack
extends PageValueType<ItemStackValueFilter> {
    public static final PageEntryItemStack INSTANCE = new PageEntryItemStack();
    private static final JsonTypeTags TAGS = new JsonTypeTags("buildcraft.guide.contents.item_stacks");

    @Override
    public Class<ItemStackValueFilter> getEntryClass() {
        return ItemStackValueFilter.class;
    }

    @Override
    public void iterateAllDefault(IEntryLinkConsumer consumer) {
        block2: for (Item item : ForgeRegistries.ITEMS) {
            if (!GuideManager.INSTANCE.objectsAdded.add(item)) continue;
            NonNullList stacks = NonNullList.func_191196_a();
            item.func_150895_a(CreativeTabs.field_78027_g, stacks);
            for (int i = 0; i < stacks.size(); ++i) {
                ItemStack stack = (ItemStack)stacks.get(i);
                try {
                    consumer.addChild(TAGS, new PageLinkItemStack(false, stack));
                }
                catch (RuntimeException e) {
                    throw new Error("Failed to create a page link for " + item.getRegistryName() + " " + item.getClass() + " (" + stack.serializeNBT() + ")", e);
                }
                if (i > 50) continue block2;
            }
        }
    }

    @Override
    public IScriptableRegistry.OptionallyDisabled<PageEntry<ItemStackValueFilter>> deserialize(ResourceLocation name, JsonObject json, JsonDeserializationContext ctx) {
        boolean matchNbt;
        boolean matchMeta;
        ItemStack stack;
        JsonElement jStack = json.get("stack");
        if (jStack == null) {
            throw new JsonSyntaxException("Expected either a string or an object for 'stack', but got nothing for " + json);
        }
        if (jStack.isJsonPrimitive()) {
            String str = JsonUtils.func_151206_a((JsonElement)jStack, (String)"stack");
            if (str.startsWith("{") && str.endsWith("}")) {
                stack = MarkdownPageLoader.loadComplexItemStack(str.substring(1, str.length() - 1));
                stack.func_190920_e(1);
                matchMeta = true;
                matchNbt = stack.func_77942_o();
            } else {
                ResourceLocation loc;
                Item item;
                if (str.startsWith("(") && str.endsWith(")")) {
                    str = str.substring(1, str.length() - 1);
                }
                if ((item = (Item)ForgeRegistries.ITEMS.getValue(loc = new ResourceLocation(str))) == null) {
                    if (RegistryConfig.hasItemBeenDisabled(loc)) {
                        return new IScriptableRegistry.OptionallyDisabled<PageEntry<ItemStackValueFilter>>("The item '" + loc + "' has been disabled.");
                    }
                    throw new JsonSyntaxException("Invalid item: " + str);
                }
                stack = new ItemStack(item);
                matchMeta = false;
                matchNbt = false;
            }
        } else {
            throw new AbstractMethodError("// TODO: Implement this!");
        }
        if (stack.func_190926_b()) {
            throw new JsonSyntaxException("Unknown item " + jStack);
        }
        ItemStackValueFilter filter = new ItemStackValueFilter(new ItemStackKey(stack), matchMeta, matchNbt);
        return new IScriptableRegistry.OptionallyDisabled<PageEntry<ItemStackValueFilter>>(new PageEntry<ItemStackValueFilter>(this, name, json, filter));
    }

    @Override
    public String getTitle(ItemStackValueFilter value) {
        return value.stack.baseStack.func_82833_r();
    }

    @Override
    public List<String> getTooltip(ItemStackValueFilter value) {
        return GuiUtil.getFormattedTooltip(value.stack.baseStack);
    }

    @Override
    public boolean matches(ItemStackValueFilter entry, Object obj) {
        if (obj instanceof ItemStackValueFilter) {
            obj = ((ItemStackValueFilter)obj).stack.baseStack;
        }
        if (obj instanceof ItemStackKey) {
            obj = ((ItemStackKey)obj).baseStack;
        }
        if (obj instanceof ItemStack) {
            ItemStack base = entry.stack.baseStack;
            ItemStack test = (ItemStack)obj;
            if (base.func_190926_b() || test.func_190926_b()) {
                return false;
            }
            if (base.func_77973_b() != test.func_77973_b()) {
                return false;
            }
            if (entry.matchMeta && base.func_77960_j() != test.func_77960_j()) {
                return false;
            }
            return !entry.matchNbt || ItemStack.func_77970_a((ItemStack)base, (ItemStack)test);
        }
        return false;
    }

    @Override
    @Nullable
    public ISimpleDrawable createDrawable(ItemStackValueFilter value) {
        return new GuiStack(value.stack.baseStack);
    }

    @Override
    public Object getBasicValue(ItemStackValueFilter value) {
        return value.stack.baseStack.func_77973_b();
    }

    @Override
    public void addPageEntries(ItemStackValueFilter value, GuiGuide gui, List<GuidePart> parts) {
        XmlPageLoader.appendAllCrafting(value.stack.baseStack, parts, gui);
    }
}

