/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.parts.GuideChapter;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.pos.GuiRectangle;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;

public abstract class GuidePageBase
extends GuidePart {
    private int index = 0;
    protected int numPages = -1;

    public GuidePageBase(GuiGuide gui) {
        super(gui);
    }

    protected final int getIndex() {
        return this.index;
    }

    public final void nextPage() {
        if (this.index + 2 < this.numPages) {
            this.index += 2;
        }
    }

    public final void lastPage() {
        this.index -= 2;
        if (this.index < 0) {
            this.index = 0;
        }
    }

    protected final void goToPage(int page) {
        this.index = page / 2;
        this.index *= 2;
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.numPages >= 0 && this.index >= this.numPages) {
            this.index = this.numPages - 1;
        }
    }

    public int getPage() {
        return this.index;
    }

    public int getPageCount() {
        return this.numPages;
    }

    public void tick() {
    }

    @Override
    public final GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        return current;
    }

    public abstract String getTitle();

    public boolean shouldPersistHistory() {
        return true;
    }

    @Nullable
    public GuidePageBase createReloaded() {
        return null;
    }

    public abstract List<GuideChapter> getChapters();

    protected GuidePart getClicked(Iterable<GuidePart> iterable, int x, int y, int width, int height, int mouseX, int mouseY, int index) {
        GuidePart.PagePosition pos = new GuidePart.PagePosition(0, 0);
        for (GuidePart part : iterable) {
            pos = part.renderIntoArea(x, y, width, height, pos, -1);
            if (pos.page == index && part.wasHovered) {
                return part;
            }
            if (pos.page <= index) continue;
            return null;
        }
        return null;
    }

    public void renderFirstPage(int x, int y, int width, int height) {
        this.renderPage(x, y, width, height, this.index);
    }

    public void renderSecondPage(int x, int y, int width, int height) {
        this.renderPage(x, y, width, height, this.index + 1);
    }

    protected void renderPage(int x, int y, int width, int height, int index) {
        if (index % 2 == 0) {
            if (index != 0) {
                GuiIcon icon = GuiGuide.TURN_BACK;
                GuiRectangle turnBox = new GuiRectangle(x - 30, y + height, icon.width + 30, icon.height + 30);
                if (turnBox.contains(this.gui.mouse)) {
                    icon = GuiGuide.TURN_BACK_HOVERED;
                }
                icon.drawAt(turnBox.offset(30.0, 0.0));
            }
            String text = index + 1 + " / " + this.numPages;
            double textX = (double)x + GuiGuide.PAGE_LEFT_TEXT.width / 2.0 - (double)(this.getFontRenderer().getStringWidth(text) / 2);
            this.getFontRenderer().drawString(text, (int)textX, y + height + 6, 0);
        } else {
            if (index + 1 < this.numPages) {
                GuiIcon icon = GuiGuide.TURN_FORWARDS;
                GuiRectangle turnBox = new GuiRectangle(x + width - icon.width, y + height, icon.width + 30, icon.height + 30);
                if (turnBox.contains(this.gui.mouse)) {
                    icon = GuiGuide.TURN_FORWARDS_HOVERED;
                }
                icon.drawAt(turnBox);
            }
            if (index + 1 <= this.numPages) {
                String text = index + 1 + " / " + this.numPages;
                double textX = (double)x + (GuiGuide.PAGE_RIGHT_TEXT.width - (double)this.getFontRenderer().getStringWidth(text)) / 2.0;
                this.getFontRenderer().drawString(text, (int)textX, y + height + 6, 0);
            }
        }
    }

    @Override
    public final GuidePart.PagePosition handleMouseClick(int x, int y, int width, int height, GuidePart.PagePosition current, int index, int mouseX, int mouseY) {
        return current;
    }

    public void handleMouseClick(int x, int y, int width, int height, int mouseX, int mouseY, int mouseButton, int index, boolean isEditing) {
        if (index % 2 == 0) {
            if (index != 0) {
                GuiIcon icon = GuiGuide.TURN_BACK;
                GuiRectangle turnBox = new GuiRectangle(x - 30, y + height, icon.width + 30, icon.height + 30);
                if (turnBox.contains(this.gui.mouse)) {
                    this.lastPage();
                }
            }
        } else if (index + 1 < this.numPages) {
            GuiIcon icon = GuiGuide.TURN_FORWARDS;
            GuiRectangle turnBox = new GuiRectangle(x + width - icon.width, y + height, icon.width + 30, icon.height + 30);
            if (turnBox.contains(this.gui.mouse)) {
                this.nextPage();
            }
        }
    }

    @Override
    public final void handleMouseDragPartial(int startX, int startY, int currentX, int currentY, int button) {
    }

    @Override
    public final void handleMouseDragFinish(int startX, int startY, int endX, int endY, int button) {
    }

    public boolean keyTyped(char typedChar, int keyCode) throws IOException {
        return false;
    }
}

