/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.GuideManager;
import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.gui.GuiStack;
import buildcraft.lib.misc.GuiUtil;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class PageLinkItemStack
extends PageLink {
    public final ItemStack stack;
    public final List<String> tooltip;
    public final String searchText;

    public PageLinkItemStack(boolean startVisible, ItemStack stack) {
        super(PageLinkItemStack.createPageLine(stack), startVisible);
        this.stack = stack;
        this.tooltip = GuiUtil.getFormattedTooltip(stack);
        String joinedTooltip = this.tooltip.stream().collect(Collectors.joining(" ", "", ""));
        this.searchText = TextFormatting.func_110646_a((String)joinedTooltip).toLowerCase(Locale.ROOT);
    }

    private static PageLine createPageLine(ItemStack stack) {
        GuiStack icon = new GuiStack(stack);
        String title = stack.func_82833_r();
        if (title == null) {
            Item item = stack.func_77973_b();
            String info = item.getRegistryName() + " " + item.getClass() + " (" + stack.serializeNBT() + ")";
            BCLog.logger.warn("[lib.guide] Found null display name! " + info);
            title = "!!NULL stack.getDisplayName(): " + info;
        }
        return new PageLine(icon, icon, 2, title, true);
    }

    @Override
    public String getSearchName() {
        return this.searchText;
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip.size() == 1 ? null : this.tooltip;
    }

    @Override
    public void appendTooltip(GuiGuide gui) {
        if (this.tooltip.size() > 1) {
            gui.tooltipStack = this.stack;
        }
    }

    @Override
    public GuidePageFactory getFactoryLink() {
        return GuideManager.INSTANCE.getPageFor(this.stack);
    }
}

