/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.lib.client.guide.GuiGuide;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.GuidePartItem;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.recipe.ChangingItemStack;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class GuideSmelting
extends GuidePartItem {
    public static final GuiIcon SMELTING_ICON = new GuiIcon(GuiGuide.ICONS_2, 119.0, 54.0, 80.0, 54.0);
    public static final GuiRectangle OFFSET = new GuiRectangle((GuiGuide.PAGE_LEFT_TEXT.width - (double)GuideSmelting.SMELTING_ICON.width) / 2.0, 0.0, GuideSmelting.SMELTING_ICON.width, GuideSmelting.SMELTING_ICON.height);
    public static final GuiRectangle IN_POS = new GuiRectangle(1.0, 1.0, 16.0, 16.0);
    public static final GuiRectangle OUT_POS = new GuiRectangle(59.0, 19.0, 16.0, 16.0);
    public static final GuiRectangle FURNACE_POS = new GuiRectangle(1.0, 37.0, 16.0, 16.0);
    public static final int PIXEL_HEIGHT = 60;
    private final ChangingItemStack input;
    private final ChangingItemStack output;
    private final ItemStack furnace;
    private final int hash;

    public GuideSmelting(GuiGuide gui, @Nonnull ItemStack input, @Nonnull ItemStack output) {
        super(gui);
        this.input = new ChangingItemStack(input);
        this.output = new ChangingItemStack(output);
        this.furnace = new ItemStack(Blocks.field_150460_al);
        this.hash = Objects.hash(input, output);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GuideSmelting other = (GuideSmelting)obj;
        if (this.hash != other.hash) {
            return false;
        }
        return this.input.equals(other.input) && this.output.equals(other.output);
    }

    @Override
    public GuidePart.PagePosition renderIntoArea(int x, int y, int width, int height, GuidePart.PagePosition current, int index) {
        if (current.pixel + 60 > height) {
            current = current.newPage();
        }
        x = (int)((double)x + GuideSmelting.OFFSET.x);
        y = (int)((double)y + (GuideSmelting.OFFSET.y + (double)current.pixel));
        if (current.page == index) {
            SMELTING_ICON.drawAt(x, y);
            GlStateManager.func_179091_B();
            RenderHelper.func_74520_c();
            this.drawItemStack((ItemStackKey)this.input.get(), x + (int)GuideSmelting.IN_POS.x, y + (int)GuideSmelting.IN_POS.y);
            this.drawItemStack((ItemStackKey)this.output.get(), x + (int)GuideSmelting.OUT_POS.x, y + (int)GuideSmelting.OUT_POS.y);
            this.drawItemStack(this.furnace, x + (int)GuideSmelting.FURNACE_POS.x, y + (int)GuideSmelting.FURNACE_POS.y);
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
        }
        current = current.nextLine(60, height);
        return current;
    }

    @Override
    public GuidePart.PagePosition handleMouseClick(int x, int y, int width, int height, GuidePart.PagePosition current, int index, int mouseX, int mouseY) {
        if (current.pixel + 60 > height) {
            current = current.newPage();
        }
        x = (int)((double)x + GuideSmelting.OFFSET.x);
        y = (int)((double)y + (GuideSmelting.OFFSET.y + (double)current.pixel));
        if (current.page == index) {
            this.testClickItemStack((ItemStackKey)this.input.get(), x + (int)GuideSmelting.IN_POS.x, y + (int)GuideSmelting.IN_POS.y);
            this.testClickItemStack((ItemStackKey)this.output.get(), x + (int)GuideSmelting.OUT_POS.x, y + (int)GuideSmelting.OUT_POS.y);
            this.testClickItemStack(this.furnace, x + (int)GuideSmelting.FURNACE_POS.x, y + (int)GuideSmelting.FURNACE_POS.y);
        }
        current = current.nextLine(60, height);
        return current;
    }
}

