/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideAssemblyRecipes;
import buildcraft.lib.client.guide.parts.recipe.GuideCraftingRecipes;
import buildcraft.lib.client.guide.parts.recipe.GuideSmeltingRecipes;
import buildcraft.lib.client.guide.parts.recipe.IStackRecipes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class RecipeLookupHelper {
    public static final Map<String, IStackRecipes> handlerTypes = new HashMap<String, IStackRecipes>();

    public static List<GuidePartFactory> getAllUsages(@Nonnull ItemStack stack) {
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IStackRecipes handler : handlerTypes.values()) {
            List<GuidePartFactory> recipes = handler.getUsages(stack);
            if (recipes == null) continue;
            list.addAll(recipes);
        }
        return list;
    }

    public static List<GuidePartFactory> getAllRecipes(@Nonnull ItemStack stack) {
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IStackRecipes handler : handlerTypes.values()) {
            List<GuidePartFactory> recipes = handler.getRecipes(stack);
            if (recipes == null) continue;
            list.addAll(recipes);
        }
        return list;
    }

    static {
        handlerTypes.put("smelting", GuideSmeltingRecipes.INSTANCE);
        handlerTypes.put("crafting", GuideCraftingRecipes.INSTANCE);
        handlerTypes.put("assembling", GuideAssemblyRecipes.INSTANCE);
    }
}

