/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.ref;

import buildcraft.api.BCBlocks;
import buildcraft.api.statements.IStatement;
import buildcraft.core.BCCoreBlocks;
import buildcraft.core.BCCoreItems;
import buildcraft.lib.client.guide.entry.ItemStackValueFilter;
import buildcraft.lib.client.guide.entry.PageEntryItemStack;
import buildcraft.lib.client.guide.entry.PageEntryStatement;
import buildcraft.lib.client.guide.entry.PageValue;
import buildcraft.lib.client.guide.entry.PageValueType;
import buildcraft.lib.client.guide.ref.GuideGroupSet;
import buildcraft.silicon.BCSiliconItems;
import buildcraft.transport.BCTransportItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuideGroupManager {
    public static final List<PageValueType<?>> knownTypes = new ArrayList();
    public static final Map<ResourceLocation, GuideGroupSet> sets = new HashMap<ResourceLocation, GuideGroupSet>();
    private static final Map<Class<?>, PageValueType<?>> knownClasses = new WeakHashMap();
    private static final Map<Class<?>, Function<Object, PageValue<?>>> transformers = new WeakHashMap();

    private static void temp() {
        GuideGroupManager.addEntries("buildcraft", "pipe_power_providers", BCSiliconItems.plugPulsar, BCTransportItems.plugPowerAdaptor, new ItemStack((Block)BCCoreBlocks.engine), new ItemStack((Block)BCCoreBlocks.engine, 1, 1), new ItemStack((Block)BCCoreBlocks.engine, 1, 2)).addKeyArray(BCTransportItems.pipeItemWood, BCTransportItems.pipeItemDiaWood, BCTransportItems.pipeItemEmzuli, BCTransportItems.pipeFluidWood, BCTransportItems.pipeFluidDiaWood);
        GuideGroupManager.addEntries("buildcraft", "full_power_providers", new ItemStack((Block)BCCoreBlocks.engine, 1, 1), new ItemStack((Block)BCCoreBlocks.engine, 1, 2)).addKeyArray(BCBlocks.Builders.BUILDER, BCBlocks.Builders.FILLER, BCBlocks.Builders.QUARRY, BCBlocks.Factory.DISTILLER, BCBlocks.Factory.MINING_WELL, BCBlocks.Factory.PUMP, BCBlocks.Silicon.LASER);
        GuideGroupManager.addEntries("buildcraft", "laser_power_providers", BCBlocks.Silicon.LASER).addKeyArray(BCBlocks.Silicon.ADVANCED_CRAFTING_TABLE, BCBlocks.Silicon.ASSEMBLY_TABLE, BCBlocks.Silicon.INTEGRATION_TABLE);
        GuideGroupManager.addEntries("buildcraft", "area_markers", BCCoreBlocks.markerVolume, BCCoreItems.volumeBox).addKeyArray(BCBlocks.Builders.QUARRY, BCBlocks.Builders.ARCHITECT, BCBlocks.Builders.FILLER);
    }

    public static <F, T> void addTransformer(Class<F> fromClass, Class<T> toClass, Function<F, T> transform) {
        if (GuideGroupManager.isValidClass(fromClass)) {
            throw new IllegalArgumentException("You cannot register a transformer from an already-registered class!");
        }
        PageValueType<?> destType = GuideGroupManager.getEntryType(toClass);
        if (destType == null) {
            Function<Object, PageValue<?>> destTransform = GuideGroupManager.getTransform(toClass);
            if (destTransform != null) {
                Function<Object, PageValue> realTransform = o -> {
                    Object from = fromClass.cast(o);
                    Object to = transform.apply(from);
                    return (PageValue)destTransform.apply(to);
                };
                transformers.put(fromClass, realTransform);
                return;
            }
            throw new IllegalArgumentException("You cannot register a transformer to an unregistered class!");
        }
        Function<Object, PageValue> realTransform = o -> {
            Object from = fromClass.cast(o);
            Object to = transform.apply(from);
            return destType.wrap(to);
        };
        transformers.put(fromClass, realTransform);
    }

    public static <T> void addValidClass(Class<T> clazz, PageValueType<T> type) {
        if (clazz.isArray()) {
            throw new IllegalArgumentException("Arrays are never valid!");
        }
        knownClasses.put(clazz, type);
        knownTypes.add(type);
    }

    static boolean isValidObject(Object value) {
        if (value == null) {
            return false;
        }
        return GuideGroupManager.isValidClass(value.getClass());
    }

    public static PageValue<?> toPageValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof PageValue) {
            return (PageValue)value;
        }
        PageValueType<?> entryType = GuideGroupManager.getEntryType(value.getClass());
        if (entryType != null) {
            return entryType.wrap(value);
        }
        Function<Object, PageValue<?>> transform = GuideGroupManager.getTransform(value.getClass());
        if (transform != null) {
            return transform.apply(value);
        }
        throw new IllegalArgumentException("Unknown " + value.getClass() + " - is this a programming mistake, or have you forgotton to register the class as valid?");
    }

    private static boolean isValidClass(Class<?> clazz) {
        return GuideGroupManager.getEntryType(clazz) != null;
    }

    @Nullable
    private static PageValueType<?> getEntryType(Class<?> clazz) {
        if (knownClasses.containsKey(clazz)) {
            return knownClasses.get(clazz);
        }
        PageValueType<?> type = null;
        if (!clazz.isArray()) {
            Class<?> superClazz = clazz.getSuperclass();
            if (superClazz == null || (type = GuideGroupManager.getEntryType(superClazz)) == null) {
                Class<?> cls;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (type = GuideGroupManager.getEntryType(cls = classArray[i])) == null; ++i) {
                }
            }
            knownClasses.put(clazz, type);
        }
        return type;
    }

    private static Function<Object, PageValue<?>> getTransform(Class<? extends Object> clazz) {
        Function<Object, PageValue<?>> func = transformers.get(clazz);
        if (func != null) {
            return func;
        }
        if (!clazz.isArray()) {
            Class<? extends Object> superClazz = clazz.getSuperclass();
            if (superClazz == null || (func = GuideGroupManager.getTransform(superClazz)) == null) {
                Class<?> cls;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (func = GuideGroupManager.getTransform(cls = classArray[i])) == null; ++i) {
                }
            }
            transformers.put(clazz, func);
        }
        return func;
    }

    @Nullable
    public static GuideGroupSet get(ResourceLocation group) {
        return sets.get(group);
    }

    @Nullable
    public static GuideGroupSet get(String domain, String group) {
        return GuideGroupManager.get(new ResourceLocation(domain, group));
    }

    public static GuideGroupSet getOrCreate(String domain, String group) {
        return sets.computeIfAbsent(new ResourceLocation(domain, group), GuideGroupSet::new);
    }

    public static GuideGroupSet addEntry(String domain, String group, Object value) {
        return GuideGroupManager.getOrCreate(domain, group).addSingle(value);
    }

    public static GuideGroupSet addEntries(String domain, String group, Object ... values) {
        return GuideGroupManager.getOrCreate(domain, group).addArray(values);
    }

    public static GuideGroupSet addEntries(String domain, String group, Collection<Object> values) {
        return GuideGroupManager.getOrCreate(domain, group).addCollection(values);
    }

    public static GuideGroupSet addKey(String domain, String group, Object value) {
        return GuideGroupManager.getOrCreate(domain, group).addKey(value);
    }

    public static GuideGroupSet addKeys(String domain, String group, Object ... values) {
        return GuideGroupManager.getOrCreate(domain, group).addKeyArray(values);
    }

    public static GuideGroupSet addKeys(String domain, String group, Collection<Object> values) {
        return GuideGroupManager.getOrCreate(domain, group).addKeyCollection(values);
    }

    static {
        GuideGroupManager.addValidClass(ItemStackValueFilter.class, PageEntryItemStack.INSTANCE);
        GuideGroupManager.addValidClass(IStatement.class, PageEntryStatement.INSTANCE);
        GuideGroupManager.addTransformer(ItemStack.class, ItemStackValueFilter.class, ItemStackValueFilter::new);
        GuideGroupManager.addTransformer(Item.class, ItemStack.class, ItemStack::new);
        GuideGroupManager.addTransformer(Block.class, ItemStack.class, ItemStack::new);
        GuideGroupManager.temp();
    }
}

