/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui;

import buildcraft.api.core.render.ISprite;
import buildcraft.lib.client.sprite.SpriteRaw;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.pos.IGuiArea;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiIcon
implements ISimpleDrawable {
    public final ISprite sprite;
    public final int textureSize;
    public final int width;
    public final int height;

    public GuiIcon(ISprite sprite, int textureSize) {
        this.sprite = sprite;
        this.textureSize = textureSize;
        this.width = (int)(Math.abs(sprite.getInterpU(1.0) - sprite.getInterpU(0.0)) * (double)textureSize);
        this.height = (int)(Math.abs(sprite.getInterpV(1.0) - sprite.getInterpV(0.0)) * (double)textureSize);
    }

    public GuiIcon(ResourceLocation texture, double u, double v, double width, double height, int texSize) {
        this(new SpriteRaw(texture, u, v, width, height, texSize), texSize);
    }

    public GuiIcon(ResourceLocation texture, double u, double v, double width, double height) {
        this(texture, u, v, width, height, 256);
    }

    public GuiIcon offset(double u, double v) {
        SpriteRaw raw = (SpriteRaw)this.sprite;
        double uMin = raw.uMin + u / (double)this.textureSize;
        double vMin = raw.vMin + v / (double)this.textureSize;
        return new GuiIcon(new SpriteRaw(raw.location, uMin, vMin, raw.width, raw.height), this.textureSize);
    }

    public DynamicTexture createDynamicTexture(int scale) {
        return new DynamicTexture(this.width * scale, this.height * scale);
    }

    @Override
    public void drawAt(double x, double y) {
        this.drawScaledInside(x, y, this.width, this.height);
    }

    public void drawScaledInside(IGuiArea element) {
        this.drawScaledInside(element.getX(), element.getY(), element.getWidth(), element.getHeight());
    }

    public void drawScaledInside(double x, double y, double drawnWidth, double drawnHeight) {
        GuiIcon.draw(this.sprite, x, y, x + drawnWidth, y + drawnHeight);
    }

    public void drawCustomQuad(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        this.sprite.bindTexture();
        double uMin = this.sprite.getInterpU(0.0);
        double uMax = this.sprite.getInterpU(1.0);
        double vMin = this.sprite.getInterpV(0.0);
        double vMax = this.sprite.getInterpV(1.0);
        GL11.glBegin((int)7);
        double[] q = GuiIcon.calcQ(x1, y1, x2, y2, x3, y3, x4, y4);
        GuiIcon.vertDirect(x1, y1, uMin * q[0], vMax * q[0], 0.0, q[0]);
        GuiIcon.vertDirect(x2, y2, uMax * q[1], vMax * q[1], 0.0, q[1]);
        GuiIcon.vertDirect(x3, y3, uMax * q[2], vMin * q[2], 0.0, q[2]);
        GuiIcon.vertDirect(x4, y4, uMin * q[3], vMin * q[3], 0.0, q[3]);
        GL11.glEnd();
    }

    private static double[] calcQ(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double t;
        double cx;
        double cy;
        double s;
        double ax = x3 - x1;
        double by = y4 - y2;
        double ay = y3 - y1;
        double bx = x4 - x2;
        double cross = ax * by - ay * bx;
        if (cross != 0.0 && (s = (ax * (cy = y1 - y2) - ay * (cx = x1 - x2)) / cross) > 0.0 && s < 1.0 && (t = (bx * cy - by * cx) / cross) > 0.0 && t < 1.0) {
            double q0 = 1.0 / (1.0 - t);
            double q1 = 1.0 / (1.0 - s);
            double q2 = 1.0 / t;
            double q3 = 1.0 / s;
            return new double[]{q0, q1, q2, q3};
        }
        return new double[]{1.0, 1.0, 1.0, 1.0};
    }

    private static void vertDirect(double x, double y, double s, double t, double r, double q) {
        GL11.glTexCoord4d((double)s, (double)t, (double)r, (double)q);
        GL11.glVertex2d((double)x, (double)y);
    }

    public void drawCutInside(IGuiArea element) {
        this.drawCutInside(element.getX(), element.getY(), element.getWidth(), element.getHeight());
    }

    public void drawCutInside(double x, double y, double displayWidth, double displayHeight) {
        this.sprite.bindTexture();
        displayWidth = Math.min((double)this.width, displayWidth);
        displayHeight = Math.min((double)this.height, displayHeight);
        double xMin = x;
        double yMin = y;
        double xMax = x + displayWidth;
        double yMax = y + displayHeight;
        double uMin = this.sprite.getInterpU(0.0);
        double vMin = this.sprite.getInterpV(0.0);
        double uMax = this.sprite.getInterpU(displayWidth / (double)this.width);
        double vMax = this.sprite.getInterpV(displayHeight / (double)this.height);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GuiIcon.vertex(vb, xMin, yMax, uMin, vMax);
        GuiIcon.vertex(vb, xMax, yMax, uMax, vMax);
        GuiIcon.vertex(vb, xMax, yMin, uMax, vMin);
        GuiIcon.vertex(vb, xMin, yMin, uMin, vMin);
        tess.func_78381_a();
    }

    public static void drawAt(ISprite sprite, double x, double y, double size) {
        GuiIcon.drawAt(sprite, x, y, size, size);
    }

    public static void drawAt(ISprite sprite, double x, double y, double width, double height) {
        GuiIcon.draw(sprite, x, y, x + width, y + height);
    }

    public static void draw(ISprite sprite, double xMin, double yMin, double xMax, double yMax) {
        sprite.bindTexture();
        double uMin = sprite.getInterpU(0.0);
        double vMin = sprite.getInterpV(0.0);
        double uMax = sprite.getInterpU(1.0);
        double vMax = sprite.getInterpV(1.0);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder vb = tess.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        GuiIcon.vertex(vb, xMin, yMax, uMin, vMax);
        GuiIcon.vertex(vb, xMax, yMax, uMax, vMax);
        GuiIcon.vertex(vb, xMax, yMin, uMax, vMin);
        GuiIcon.vertex(vb, xMin, yMin, uMin, vMin);
        tess.func_78381_a();
    }

    private static void vertex(BufferBuilder vb, double x, double y, double u, double v) {
        vb.func_181662_b(x, y, 0.0);
        vb.func_187315_a(u, v);
        vb.func_181675_d();
    }
}

