/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.item;

import buildcraft.api.core.BCLog;
import buildcraft.lib.registry.CreativeTabManager;
import buildcraft.lib.registry.RegistryConfig;
import buildcraft.lib.registry.TagManager;
import gnu.trove.map.hash.TIntObjectHashMap;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IItemBuildCraft {
    public String id();

    default public void init() {
        Item thisItem = (Item)this;
        thisItem.func_77655_b(TagManager.getTag(this.id(), TagManager.EnumTagType.UNLOCALIZED_NAME));
        thisItem.setRegistryName(TagManager.getTag(this.id(), TagManager.EnumTagType.REGISTRY_NAME));
        thisItem.func_77637_a(CreativeTabManager.getTab(TagManager.getTag(this.id(), TagManager.EnumTagType.CREATIVE_TAB)));
    }

    @SideOnly(value=Side.CLIENT)
    default public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        this.addVariant(variants, 0, "");
    }

    default public void addVariant(TIntObjectHashMap<ModelResourceLocation> variants, int meta, String suffix) {
        String tag = TagManager.getTag(this.id(), TagManager.EnumTagType.MODEL_LOCATION);
        variants.put(meta, (Object)new ModelResourceLocation(tag + suffix, "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    default public void registerVariants() {
        Item thisItem = (Item)this;
        TIntObjectHashMap variants = new TIntObjectHashMap();
        this.addModelVariants((TIntObjectHashMap<ModelResourceLocation>)variants);
        for (int key : variants.keys()) {
            ModelResourceLocation variant = (ModelResourceLocation)variants.get(key);
            if (RegistryConfig.DEBUG) {
                BCLog.logger.info("[lib.registry][" + thisItem.getRegistryName() + "] Registering a variant " + variant + " for damage " + key);
            }
            ModelLoader.setCustomModelResourceLocation((Item)thisItem, (int)key, (ModelResourceLocation)variant);
        }
    }
}

