/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.lib.misc.PositionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class VolumeUtil {
    public static void iterateCone(World world, BlockPos start, EnumFacing direction, int distance, boolean edges, VolumeIterator iter) {
        Cone cone = edges ? Cone.SQUARE : Cone.SQUARE;
        VolumeUtil.iterateVolume(world, start, direction, distance, cone, iter);
    }

    public static void iterateVolume(World world, BlockPos start, EnumFacing direction, int distance, VolumeProducer producer, VolumeIterator iter) {
        List<VisiblePos> volume = producer.getVolume(world, start, direction, distance);
        HashSet<BlockPos> allVisible = new HashSet<BlockPos>();
        allVisible.add(start);
        for (VisiblePos possible : volume) {
            HashSet<BlockPos> unknown = new HashSet<BlockPos>(possible.required);
            unknown.removeAll(allVisible);
            boolean visible = true;
            for (BlockPos p : unknown) {
                if (world.func_175623_d(p)) {
                    allVisible.add(p);
                    continue;
                }
                visible = false;
                break;
            }
            iter.takePos(world, start, possible.pos, visible);
        }
    }

    public static interface VolumeIterator {
        public void takePos(World var1, BlockPos var2, BlockPos var3, boolean var4);
    }

    public static enum Cone implements VolumeProducer
    {
        SQUARE(true),
        PYRAMID(false);

        private final boolean edges;

        private Cone(boolean edges) {
            this.edges = edges;
        }

        @Override
        public List<VisiblePos> getVolume(World world, BlockPos start, EnumFacing direction, int distance) {
            EnumFacing.Axis axisJ;
            EnumFacing.Axis axisI;
            ArrayList<VisiblePos> list = new ArrayList<VisiblePos>();
            switch (direction.func_176740_k()) {
                case X: {
                    axisI = EnumFacing.Axis.Y;
                    axisJ = EnumFacing.Axis.Z;
                    break;
                }
                case Y: {
                    axisI = EnumFacing.Axis.X;
                    axisJ = EnumFacing.Axis.Z;
                    break;
                }
                default: {
                    axisI = EnumFacing.Axis.X;
                    axisJ = EnumFacing.Axis.Y;
                }
            }
            EnumFacing faceI = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axisI);
            EnumFacing faceJ = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axisJ);
            BlockPos coneCenter = start;
            for (int d = 0; d < distance; ++d) {
                coneCenter = coneCenter.func_177972_a(direction);
                for (int i = -d; i <= d; ++i) {
                    for (int j = -d; j <= d; ++j) {
                        int dist;
                        if (!this.edges && (dist = Math.abs(i) + Math.abs(j)) > d) continue;
                        BlockPos posAt = coneCenter.func_177967_a(faceI, i).func_177967_a(faceJ, j);
                        list.add(new VisiblePos(posAt, start));
                    }
                }
            }
            return list;
        }
    }

    public static interface VolumeProducer {
        public List<VisiblePos> getVolume(World var1, BlockPos var2, EnumFacing var3, int var4);
    }

    public static class VisiblePos {
        public final BlockPos pos;
        public final List<BlockPos> required;

        public VisiblePos(BlockPos pos, BlockPos to) {
            this.pos = pos;
            this.required = PositionUtil.getAllOnPath(pos, to);
        }
    }
}

