/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.script;

import buildcraft.api.registry.EventBuildCraftReload;
import buildcraft.api.registry.IReloadableRegistry;
import buildcraft.api.registry.IReloadableRegistryManager;
import buildcraft.api.registry.IScriptableRegistry;
import buildcraft.lib.misc.JsonUtil;
import buildcraft.lib.script.ScriptableRegistry;
import buildcraft.lib.script.SimpleReloadableRegistry;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public enum ReloadableRegistryManager implements IReloadableRegistryManager
{
    DATA_PACKS(IReloadableRegistry.PackType.DATA_PACK),
    RESOURCE_PACKS(IReloadableRegistry.PackType.RESOURCE_PACK);

    private final IReloadableRegistry.PackType sourceType;
    private final BiMap<String, IReloadableRegistry<?>> registries = HashBiMap.create();
    private boolean isReloading;
    private int reloadCount = 0;

    private ReloadableRegistryManager(IReloadableRegistry.PackType sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    public IReloadableRegistry.PackType getType() {
        return this.sourceType;
    }

    public void reloadAll() {
        this.reload(new HashSet(this.registries.values()));
    }

    @Override
    public void reload(IReloadableRegistry<?> registry) {
        this.reload(Collections.singleton(registry));
    }

    @Override
    public void reload(IReloadableRegistry<?> ... all) {
        this.reload(new HashSet(Arrays.asList(all)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(Set<IReloadableRegistry<?>> set) {
        if (this.isInReload()) {
            throw new IllegalStateException("Cannot reload while we are reloading!");
        }
        try {
            this.isReloading = true;
            MinecraftForge.EVENT_BUS.post((Event)new EventBuildCraftReload.BeforeClear(this, set));
            set.forEach(registry -> registry.getReloadableEntryMap().clear());
            MinecraftForge.EVENT_BUS.post((Event)new EventBuildCraftReload.PreLoad(this, set));
            GsonBuilder builder = new GsonBuilder();
            JsonUtil.registerTypeAdaptors(builder);
            MinecraftForge.EVENT_BUS.post((Event)new EventBuildCraftReload.PopulateGson(this, set, builder));
            Gson gson = builder.create();
            for (IReloadableRegistry<?> registry2 : set) {
                if (!(registry2 instanceof ScriptableRegistry)) continue;
                ((ScriptableRegistry)registry2).loadScripts(gson);
            }
            MinecraftForge.EVENT_BUS.post((Event)new EventBuildCraftReload.PostLoad(this, set));
        }
        finally {
            ++this.reloadCount;
            this.isReloading = false;
        }
        MinecraftForge.EVENT_BUS.post((Event)new EventBuildCraftReload.FinishLoad(this, set));
    }

    @Override
    public boolean isInReload() {
        return this.isReloading;
    }

    @Override
    public int getReloadCount() {
        return this.reloadCount;
    }

    @Override
    public Map<String, IReloadableRegistry<?>> getAllRegistries() {
        return this.registries;
    }

    @Override
    public <R> IReloadableRegistry<R> createRegistry(String name) {
        SimpleReloadableRegistry registry = new SimpleReloadableRegistry(this);
        this.getAllRegistries().put(name, registry);
        return registry;
    }

    @Override
    public <R> IScriptableRegistry<R> createScriptableRegistry(String entryPath) {
        ScriptableRegistry registry = new ScriptableRegistry(this, entryPath);
        this.registerRegistry(registry);
        return registry;
    }

    @Override
    public void registerRegistry(String entryType, IScriptableRegistry<?> registry) {
        if (entryType.indexOf(58) != -1) {
            throw new IllegalArgumentException("The entry type must be a valid resource path! (so it must not contain a colon)");
        }
        this.registries.put((Object)entryType, registry);
    }
}

