/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.script;

import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.GenericExpressionCompiler;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.script.LineData;
import buildcraft.lib.script.ScriptAliasDocumentation;
import buildcraft.lib.script.ScriptAliasFunction;
import buildcraft.lib.script.ScriptableRegistry;
import buildcraft.lib.script.SourceFile;
import buildcraft.lib.script.SourceLine;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class SimpleScript {
    public static final boolean DEBUG = BCDebugging.shouldDebugLog("lib.script");
    private static final FunctionContext CONTEXT = DefaultContexts.createWithAll("scripts");
    static final Gson GSON = new Gson();
    static final Map<String, ScriptActionLoader> functions = new HashMap<String, ScriptActionLoader>();
    static BufferedWriter logWriter;
    public final String domain;
    public final Path scriptDirRoot;
    public final Path scriptFolder;
    public final String scriptName;
    public final List<ScriptAction> actions = new ArrayList<ScriptAction>();
    public final Map<String, ScriptAliasFunction> customFunctions = new HashMap<String, ScriptAliasFunction>();
    final MutableLineList lines;
    boolean isDebugEnabled;
    Set<String> printedFunctions = null;
    ScriptAliasDocumentation currentDocumentation = null;
    private static File logDir;

    public SimpleScript(ScriptableRegistry<?> registry, Path scriptDirRoot, String scriptDomain, Path scriptFolder, Path scriptFile, List<Path> roots, List<String> scriptContents) {
        LineToken token;
        this.scriptDirRoot = scriptDirRoot;
        this.domain = scriptDomain;
        this.scriptFolder = scriptFolder;
        this.scriptName = scriptFile.getFileName().toString();
        this.logPure("Found script: ", scriptFile);
        this.lines = new MutableLineList(new SourceFile(this.scriptName, scriptContents.size()), scriptContents);
        int conditionalLevel = 0;
        int skipLevel = 0;
        block22: while ((token = this.lines.nextToken(true)) != null) {
            if (!token.isValid) continue;
            switch (token.type) {
                case COMMENT: {
                    continue block22;
                }
                case FUNC_DOCS: {
                    this.currentDocumentation = ScriptAliasDocumentation.parse(token.lines);
                    continue block22;
                }
                case BACKTICK_STRING: 
                case QUOTED_STRING: {
                    this.log("Found unrelated quoted string!");
                    continue block22;
                }
                case SEPARATE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown/new enum value: " + (Object)((Object)token.type));
                }
            }
            if (token.type == TokenType.COMMENT) continue;
            assert (token.lines.length == 1) : "The parser shouldn't return tokens with a different length for TokenType.SEPARATE!";
            String function = token.lines[0];
            assert (!function.isEmpty()) : "The parser shouldn't return empty tokens for TokenType.SEPARATE!";
            if (skipLevel > 0) {
                if (!"endif".equals(function)) continue;
                --skipLevel;
                --conditionalLevel;
                this.log("endif -- skipped block");
                continue;
            }
            switch (function) {
                case "if": {
                    ++conditionalLevel;
                    LineToken conditional = this.lines.nextToken(false);
                    if (conditional == null) {
                        this.log("Expected a conditional expression in a quote, but found nothing!");
                        continue block22;
                    }
                    if (!conditional.isValid || !conditional.type.isString) {
                        this.log("Found a token that wasn't a string! (or was invalid) '" + Arrays.toString(conditional.lines));
                        continue block22;
                    }
                    String func = conditional.joinLines(false);
                    boolean shouldCall = false;
                    try {
                        shouldCall = GenericExpressionCompiler.compileExpressionBoolean(func, CONTEXT).evaluate();
                        this.log("(" + func + ") = " + shouldCall);
                    }
                    catch (InvalidExpressionException e) {
                        this.log("Invalid " + e.getMessage());
                        e.printStackTrace();
                    }
                    if (shouldCall) continue block22;
                    ++skipLevel;
                    break;
                }
                case "endif": {
                    if (conditionalLevel <= 0) {
                        this.log("cannot end if without starting one!");
                    }
                    --conditionalLevel;
                    this.log("endif -- executed block");
                    break;
                }
                case "import": {
                    LineToken srcToken = this.lines.nextToken(false);
                    if (srcToken == null || !srcToken.isValid || srcToken.type != TokenType.QUOTED_STRING) {
                        this.log("Unknown/invalid import statement!");
                        break;
                    }
                    String source = srcToken.joinLines(false);
                    List<String> replacements = this.loadLinesFromLib(source, registry, roots);
                    if (replacements == null) break;
                    LineData[] rdata = new LineData[replacements.size()];
                    SourceFile file = new SourceFile(source, replacements.size());
                    for (int i = 0; i < replacements.size(); ++i) {
                        rdata[i] = new LineData(replacements.get(i), file, i);
                    }
                    this.lines.lineIterator.next();
                    if (this.lines.replace(token.datas[0], rdata, s -> s)) continue block22;
                    this.log("Recursive import!");
                    break;
                }
                case "alias": {
                    int argCountNumber;
                    LineToken nameToken = this.lines.nextToken(false);
                    if (nameToken == null || !nameToken.isValid || nameToken.type != TokenType.SEPARATE) {
                        this.log("Missing name!");
                        break;
                    }
                    function = nameToken.joinLines(false);
                    int startLine = this.lines.lineIterator.previousIndex();
                    LineToken argToken = this.lines.nextToken(false);
                    if (argToken == null) {
                        this.log("Missing argument count!");
                        break;
                    }
                    if (!argToken.isValid || argToken.type != TokenType.SEPARATE) {
                        this.log("Invalid argument count!");
                        break;
                    }
                    String argCount = argToken.joinLines(false);
                    try {
                        argCountNumber = Integer.parseInt(argCount);
                        if (argCountNumber < 0 || argCountNumber > 50) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        this.log("Expected a number between 0 and 50, but got " + argCount);
                        break;
                    }
                    LineToken next = this.lines.nextToken(false);
                    if (next == null || !next.isValid) {
                        this.log("Expected replcement but got nothing!");
                        break;
                    }
                    LineToken extra = this.lines.nextToken(false);
                    if (extra != null) {
                        this.log("Found additional data!");
                        break;
                    }
                    LineData[] datas = new LineData[next.lines.length];
                    for (int i = 0; i < datas.length; ++i) {
                        String text = next.lines[i];
                        LineData data = next.datas[i];
                        datas[i] = new LineData(data, text);
                    }
                    ScriptAliasFunction.AliasBuilder builder = new ScriptAliasFunction.AliasBuilder();
                    builder.name = function;
                    builder.argCount = argCountNumber;
                    builder.rawOutputs = datas;
                    builder.startLine = startLine;
                    builder.docs = this.currentDocumentation;
                    this.customFunctions.put(function, new ScriptAliasFunction(builder));
                    this.currentDocumentation = null;
                    break;
                }
                default: {
                    ScriptActionLoader loader = functions.get(function);
                    if (loader != null) {
                        List<ScriptAction> loadedActions = loader.load(this);
                        if (loadedActions == null) continue block22;
                        this.actions.addAll(loadedActions);
                        break;
                    }
                    LineData start = token.datas[0];
                    ScriptAliasFunction alias = this.customFunctions.get(function);
                    if (alias != null) {
                        String[] values = this.parseArgValues(alias.argCount);
                        if (values == null || this.lines.replace(start, alias.rawOutput, SimpleScript.createAliasTransform(values))) continue block22;
                        this.log("Overlapped alias functions!");
                        break;
                    }
                    this.log("Unknown function " + function);
                    break;
                }
            }
        }
        this.logPure("");
    }

    private static Function<String, String> createAliasTransform(String[] values) {
        switch (values.length) {
            case 0: {
                return Function.identity();
            }
            case 1: {
                return s -> s.replace("%0", values[0]);
            }
            case 2: {
                return s -> s.replace("%0", values[0]).replace("%1", values[1]);
            }
            case 3: {
                return s -> s.replace("%0", values[0]).replace("%1", values[1]).replace("%2", values[2]);
            }
        }
        return s -> {
            for (int i = values.length - 1; i >= 0; --i) {
                s = s.replace("%" + i, values[i]);
            }
            return s;
        };
    }

    @Nullable
    private List<String> loadLinesFromLib(String from, ScriptableRegistry<?> registry, List<Path> roots) {
        int colonIndex = from.indexOf(58);
        if (colonIndex <= 0 || colonIndex + 1 == from.length()) {
            this.log("Expected a separated string (like buildcraftcore:util), but didn't find a colon in '" + from + "'");
            return null;
        }
        String libDomain = from.substring(0, colonIndex);
        String path = from.substring(colonIndex + 1);
        block4: for (Path root : roots) {
            Path full = root.resolve(libDomain + "/compat/" + registry.getEntryType() + "/" + path + ".txt");
            if (!Files.exists(full, new LinkOption[0])) continue;
            try {
                ArrayList<String> list = new ArrayList<String>(Files.readAllLines(full));
                if (list.isEmpty()) {
                    this.log("Found a library without any lines! We can't load from this! (" + root + ")");
                    continue;
                }
                if (!"~{buildcraft/json/lib}".equals(list.get(0))) {
                    this.log("Found a library that isn't declared as '~{buildcraft/json/lib}'! We can't load from this! (" + root + ")");
                    continue;
                }
                list.set(0, "// Valid library declaration was here");
                int i = 1;
                String next = (String)list.get(i);
                if ("/**".equals(next)) {
                    do {
                        if (++i >= list.size()) {
                            this.log("Found endless comment in " + root);
                            break block4;
                        }
                        next = ((String)list.get(i)).trim();
                        if (!next.endsWith("*/")) continue;
                        ++i;
                        break;
                    } while (next.startsWith("*"));
                }
                next = (String)list.get(i);
                String[] argValues = null;
                if (next.startsWith("~args")) {
                    int count;
                    String countStr = next.substring("~args".length()).trim();
                    try {
                        count = Integer.parseInt(countStr);
                        if (count < 0 || count > 50) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        this.log("Expected a number between 0 and 50, but got " + countStr);
                        break;
                    }
                    list.set(i, "// valid args: " + next);
                    argValues = this.parseArgValues(count);
                }
                if (argValues != null) {
                    for (int a = 0; a < argValues.length; ++a) {
                        for (i = 0; i < list.size(); ++i) {
                            String str = (String)list.get(i);
                            str = str.replace("${" + a + "}", argValues[a]);
                            list.set(i, str);
                        }
                    }
                }
                for (i = 0; i < list.size(); ++i) {
                    String str = (String)list.get(i);
                    str = str.replace("${domain}", this.domain);
                    list.set(i, str);
                }
                return list;
            }
            catch (IOException e) {
                this.log("" + e.getMessage());
            }
        }
        return null;
    }

    @Nullable
    private String[] parseArgValues(int count) {
        String[] args = new String[count];
        boolean invalid = false;
        for (int i = 0; i < count; ++i) {
            LineToken next = this.lines.nextToken(false);
            if (next == null) {
                this.log("Expected a value, got nothing for the " + SimpleScript.toIndexStr(i + 1) + " argument!");
                invalid = true;
                args[i] = "";
                continue;
            }
            if (!next.isValid) {
                this.log("Expected a value, got an invalid token (" + next + ") for the " + SimpleScript.toIndexStr(i + 1) + " argument!");
                invalid = true;
                args[i] = "";
                continue;
            }
            args[i] = next.joinLines(true);
        }
        if (invalid) {
            return null;
        }
        return args;
    }

    private static String toIndexStr(int val) {
        int end = val % 10;
        String strEnd = "th";
        if (end == 1) {
            strEnd = "st";
        } else if (end == 2) {
            strEnd = "nd";
        } else if (end == 3) {
            strEnd = "rd";
        }
        return val + strEnd;
    }

    private String getLineNumber() {
        if (!this.lines.lineIterator.hasPrevious()) {
            return "0";
        }
        this.lines.lineIterator.previous();
        return ((LineData)((MutableLineList)this.lines).lineIterator.next()).lineNumbers;
    }

    void log(String line) {
        SimpleScript.log0(this.getLineNumber() + ": " + line);
    }

    void log(String line, Path path) {
        SimpleScript.log0(this.getLineNumber() + ": " + line + this.scriptDirRoot.relativize(path));
    }

    void logPure(String line) {
        SimpleScript.log0(line);
    }

    void logPure(String line, Path path) {
        SimpleScript.log0(line + this.scriptDirRoot.relativize(path));
    }

    public static void logForAll(String line) {
        SimpleScript.log0(line);
    }

    private static void log0(String line) {
        if (logWriter != null) {
            try {
                logWriter.write(line);
                logWriter.newLine();
            }
            catch (IOException io) {
                BCLog.logger.warn("[lib.script] Failed to write to the log file!", (Throwable)io);
                SimpleScript.closeLog();
            }
        }
        if (DEBUG) {
            BCLog.logger.info(line);
        }
    }

    public static AutoCloseable createLogFile(String path) {
        logDir = new File(BCLibProxy.getProxy().getGameDirectory(), "logs/buildcraft/scripts");
        try {
            logDir.mkdirs();
            File logFile = new File(logDir, path + ".log");
            logFile.getParentFile().mkdirs();
            logWriter = new BufferedWriter(new FileWriter(logFile));
            return SimpleScript::closeLog;
        }
        catch (IOException io) {
            BCLog.logger.warn("[lib.script] Failed to open the log file! (" + logDir + ")", (Throwable)io);
            SimpleScript.closeLog();
            return () -> {};
        }
    }

    private static void closeLog() {
        if (logWriter != null) {
            try {
                try {
                    logWriter.flush();
                }
                finally {
                    logWriter.close();
                    logWriter = null;
                }
            }
            catch (IOException io) {
                BCLog.logger.warn("[lib.script] Failed to close the log file, so it might not be complete! (" + logDir + ")", (Throwable)io);
            }
        }
    }

    String nextSimpleArg() {
        LineToken next = this.lines.nextToken(false);
        String ret = next == null || !next.isValid || next.type != TokenType.SEPARATE ? "" : next.joinLines(false);
        return ret;
    }

    @Nullable
    String nextQuotedArg() {
        LineToken next = this.lines.nextToken(false);
        if (next == null || !next.isValid) {
            return null;
        }
        return next.joinLines(false);
    }

    @Nullable
    String[] nextQuotedArgAsArray() {
        String[] arr = null;
        LineToken next = this.lines.nextToken(false);
        if (next != null && next.isValid) {
            arr = next.lines;
        }
        return arr;
    }

    @Nullable
    JsonObject nextJson() {
        String multiLine = this.nextQuotedArg();
        try {
            return (JsonObject)GSON.fromJson(multiLine, JsonObject.class);
        }
        catch (JsonSyntaxException jse) {
            this.log("Invalid JSON: " + jse.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    JsonObject loadJson(String path) {
        Path jsonPath = this.scriptFolder.resolve(path + ".json");
        if (!Files.exists(jsonPath, new LinkOption[0])) {
            this.log("Couldn't find the resource: ", jsonPath);
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(jsonPath);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            return jsonObject;
        }
        catch (IOException io) {
            this.log("Unable to read the file! " + io.getMessage());
            return null;
        }
        catch (JsonSyntaxException jse) {
            this.log("Invalid JSON: " + jse.getMessage());
            return null;
        }
    }

    static {
        CONTEXT.put_s_b("is_mod_loaded", Loader::isModLoaded);
        functions.put("add", script -> {
            String name = script.nextQuotedArg();
            if (name == null) {
                script.log("Missing name!");
                return null;
            }
            JsonObject json = script.nextJson();
            if (json == null) {
                json = script.loadJson(name);
            }
            ResourceLocation id = new ResourceLocation(script.domain, name);
            return ImmutableList.of((Object)new ScriptActionAdd(id, json));
        });
        functions.put("remove", script -> {
            String name = script.nextQuotedArg();
            if (name == null) {
                script.log("Missing name!");
                return null;
            }
            return ImmutableList.of((Object)new ScriptActionRemove(name));
        });
        functions.put("replace", script -> {
            String toRemove = script.nextQuotedArg();
            String toAdd = script.nextQuotedArg();
            if (toRemove == null) {
                script.log("Missing to_remove!");
                return null;
            }
            if (toAdd == null) {
                script.log("Missing to_add!");
                return null;
            }
            JsonObject json = script.nextJson();
            if (json == null) {
                json = script.loadJson(toAdd);
            }
            ResourceLocation id = new ResourceLocation(script.domain, toAdd);
            return ImmutableList.of((Object)new ScriptActionReplace(toRemove, id, json, false));
        });
        functions.put("modify", script -> {
            String toRemove = script.nextQuotedArg();
            String toAdd = script.nextQuotedArg();
            if (toRemove == null) {
                script.log("Missing to_remove!");
                return null;
            }
            if (toAdd == null) {
                script.log("Missing to_add!");
                return null;
            }
            JsonObject json = script.nextJson();
            if (json == null) {
                json = script.loadJson(toAdd);
            }
            ResourceLocation id = new ResourceLocation(script.domain, toAdd);
            return ImmutableList.of((Object)new ScriptActionReplace(toRemove, id, json, true));
        });
    }

    public static class ScriptActionReplace
    extends ScriptAction {
        public final ResourceLocation toReplace;
        public final ResourceLocation name;
        public final boolean inheritTags;
        public final JsonObject json;

        public ScriptActionReplace(String toReplace, ResourceLocation name, JsonObject json, boolean inheritTags) {
            this.toReplace = new ResourceLocation(toReplace);
            this.name = name;
            this.json = json;
            this.inheritTags = inheritTags;
        }

        public ScriptActionAdd convertToAdder() {
            return new ScriptActionAdd(this.name, this.json);
        }

        @Override
        public JsonObject getJson() {
            return this.json;
        }
    }

    public static class ScriptActionAdd
    extends ScriptAction {
        public final ResourceLocation name;
        public final JsonObject json;

        public ScriptActionAdd(ResourceLocation name, JsonObject json) {
            this.name = name;
            this.json = json;
        }

        @Override
        public JsonObject getJson() {
            return this.json;
        }
    }

    public static class ScriptActionRemove
    extends ScriptAction {
        public final ResourceLocation name;

        public ScriptActionRemove(String name) {
            this.name = new ResourceLocation(name);
        }
    }

    public static abstract class ScriptAction {
        public JsonObject getJson() {
            throw new UnsupportedOperationException(this.getClass() + " doesn't support getJson()!");
        }
    }

    public static interface ScriptActionLoader {
        public List<ScriptAction> load(SimpleScript var1);
    }

    public static class MutableLineList {
        public final SourceFile file;
        private final List<LineData> lines = new LinkedList<LineData>();
        private final ListIterator<LineData> lineIterator = this.lines.listIterator();
        private int currentIndexInLine = -1;

        public MutableLineList(SourceFile file, List<String> rawData) {
            this.file = file;
            for (int i = rawData.size() - 1; i >= 0; --i) {
                String line = rawData.get(i);
                this.lineIterator.add(new LineData(line, file, i));
                this.lineIterator.previous();
            }
        }

        @Nullable
        public LineToken nextToken(boolean jumpToNextLine) {
            String line;
            LineData data;
            boolean isComment = false;
            int start = -1;
            boolean foundNextLineSymbol = false;
            block7: do {
                foundNextLineSymbol = false;
                if (!this.lineIterator.hasNext()) {
                    return null;
                }
                data = this.lineIterator.next();
                line = data.text;
                boolean isMultiLine = false;
                char end = ' ';
                block8: for (int i = Math.max(0, this.currentIndexInLine); i < line.length(); ++i) {
                    char c = line.charAt(i);
                    switch (c) {
                        case ' ': {
                            continue block8;
                        }
                        case '/': {
                            if (i + 1 == line.length()) {
                                return new LineToken(line.substring(i), data, TokenType.COMMENT, false, i, line.length());
                            }
                            isComment = true;
                            if (!line.startsWith("/**", i)) {
                                this.currentIndexInLine = -1;
                                return new LineToken(line.substring(i), data, TokenType.COMMENT, line.startsWith("//", i), i, line.length());
                            }
                            start = i + 3;
                            break block8;
                        }
                        case '\"': {
                            end = '\"';
                            start = i + 1;
                            break block8;
                        }
                        case '`': {
                            end = '`';
                            isMultiLine = true;
                            start = i + 1;
                            break block8;
                        }
                        case '\u00ac': {
                            boolean isLast = true;
                            for (int j = i; j < line.length(); ++j) {
                                if (Character.isWhitespace(line.charAt(j))) continue;
                                if (line.startsWith("//", j)) break;
                                isLast = false;
                                break;
                            }
                            if (isLast) {
                                foundNextLineSymbol = true;
                                this.currentIndexInLine = -1;
                                continue block7;
                            }
                        }
                        default: {
                            if (Character.isWhitespace(c)) continue block8;
                            for (int j = i; j < line.length(); ++j) {
                                char d = line.charAt(j);
                                if (!Character.isWhitespace(d)) continue;
                                this.currentIndexInLine = j + 1;
                                this.lineIterator.previous();
                                return new LineToken(line.substring(i, j), data, TokenType.SEPARATE, true, i, j);
                            }
                            this.currentIndexInLine = line.length();
                            this.lineIterator.previous();
                            return new LineToken(line.substring(i), data, TokenType.SEPARATE, true, i, line.length());
                        }
                    }
                }
                if (start < 0) {
                    this.currentIndexInLine = -1;
                    continue;
                }
                LineToken stringToken = this.checkForString(isComment, start, data, line, isMultiLine, end);
                if (stringToken == null) break;
                return stringToken;
            } while (jumpToNextLine || foundNextLineSymbol);
            if (start < 0) {
                return null;
            }
            return this.handleMultiLineToken(isComment, start, data, line);
        }

        @Nullable
        private LineToken handleMultiLineToken(boolean isComment, int start, LineData data, String line) {
            ArrayList<String> tokenLines = new ArrayList<String>();
            ArrayList<LineData> tokenData = new ArrayList<LineData>();
            tokenLines.add(line.substring(start));
            tokenData.add(data);
            block0: while (true) {
                if (!this.lineIterator.hasNext()) {
                    return null;
                }
                data = this.lineIterator.next();
                line = data.text;
                if (isComment) {
                    if (!line.trim().startsWith("*")) break;
                    int end = line.indexOf("*/");
                    if (end >= 0) {
                        this.currentIndexInLine = end + 2;
                        this.lineIterator.previous();
                        tokenLines.add(line.substring(0, end));
                        tokenData.add(data);
                        break;
                    }
                    line = line.substring(line.indexOf(42) + 1);
                } else {
                    for (int i = 0; i < line.length(); ++i) {
                        char c = line.charAt(i);
                        if (c == '\\') {
                            ++i;
                            continue;
                        }
                        if (c != '`') continue;
                        this.currentIndexInLine = i + 1;
                        this.lineIterator.previous();
                        tokenLines.add(line.substring(0, i));
                        tokenData.add(data);
                        break block0;
                    }
                }
                tokenLines.add(line);
                tokenData.add(data);
            }
            return new LineToken(tokenLines.toArray(new String[0]), tokenData.toArray(new LineData[0]), isComment ? TokenType.FUNC_DOCS : TokenType.BACKTICK_STRING, true, start, this.currentIndexInLine);
        }

        @Nullable
        private LineToken checkForString(boolean isComment, int start, LineData data, String line, boolean isMultiLine, char end) {
            if (isComment) {
                for (int i = start; i < line.length(); ++i) {
                    if (!line.startsWith("*/", i)) continue;
                    this.currentIndexInLine = i + 3;
                    this.lineIterator.previous();
                    return new LineToken(line.substring(start, i + 3), data, TokenType.FUNC_DOCS, true, start, i + 3);
                }
            } else {
                for (int i = start; i < line.length(); ++i) {
                    char c = line.charAt(i);
                    if (c == '\\') {
                        ++i;
                        continue;
                    }
                    if (c != end) continue;
                    this.currentIndexInLine = i + 1;
                    this.lineIterator.previous();
                    return new LineToken(line.substring(start, i), data, TokenType.QUOTED_STRING, true, start, i);
                }
                if (!isMultiLine) {
                    this.currentIndexInLine = line.length();
                    this.lineIterator.previous();
                    return new LineToken(line.substring(start + 1), data, TokenType.BACKTICK_STRING, false, start + 1, line.length());
                }
            }
            return null;
        }

        public boolean replace(LineData start, LineData[] with, Function<String, String> transform) {
            SourceLine srcLine = with[0].original;
            ArrayList<LineData> removed = new ArrayList<LineData>();
            this.lineIterator.next();
            while (true) {
                Object line;
                if ((line = this.lineIterator.previous()) == start) {
                    this.lineIterator.remove();
                    removed = null;
                    break;
                }
                if (((LineData)line).firstLineSources.contains((Object)srcLine)) {
                    BCLog.logger.warn("Overlap: " + srcLine + ", " + line);
                    break;
                }
                this.lineIterator.remove();
                removed.add((LineData)line);
            }
            if (removed != null) {
                for (LineData line : removed) {
                    this.lineIterator.add(line);
                }
                return false;
            }
            int line = this.lineIterator.nextIndex();
            for (LineData other : with) {
                this.lineIterator.add(other.createReplacement(transform.apply(other.text), srcLine, line++));
            }
            for (int i = 0; i < with.length; ++i) {
                this.lineIterator.previous();
            }
            this.currentIndexInLine = -1;
            return true;
        }

        public int size() {
            return this.lines.size();
        }
    }

    public static final class LineToken {
        public final String[] lines;
        public final LineData[] datas;
        public final TokenType type;
        public final boolean isValid;
        public final int startIndex;
        public final int endIndex;

        public LineToken(String singleLine, LineData data, TokenType type, boolean isValid, int startIndex, int endIndex) {
            this(new String[]{singleLine}, new LineData[]{data}, type, isValid, startIndex, endIndex);
        }

        public String joinLines(boolean separateWithNewLine) {
            switch (this.lines.length) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.lines[0];
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.lines[0]);
            for (int i = 1; i < this.lines.length; ++i) {
                if (separateWithNewLine) {
                    sb.append('\n');
                }
                sb.append(this.lines[i]);
            }
            return sb.toString();
        }

        public LineToken(String[] lines, LineData[] datas, TokenType type, boolean isValid, int startIndex, int endIndex) {
            if (type == TokenType.BACKTICK_STRING || type == TokenType.QUOTED_STRING) {
                int ctype = type == TokenType.BACKTICK_STRING ? 96 : 34;
                StringBuilder sb = new StringBuilder();
                for (int l = 0; l < lines.length; ++l) {
                    String line = lines[l];
                    if (line.length() <= 1) continue;
                    for (int i = 0; i < line.length(); ++i) {
                        char n;
                        char c = line.charAt(i);
                        char c2 = n = i + 1 == line.length() ? (char)'-' : (char)line.charAt(i + 1);
                        if (c == '\\' && n == ctype) {
                            ++i;
                            sb.append(n);
                            continue;
                        }
                        sb.append(c);
                    }
                    lines[l] = sb.toString();
                    sb.setLength(0);
                }
            }
            this.lines = lines;
            this.datas = datas;
            this.type = type;
            this.isValid = isValid;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }

    public static enum TokenType {
        QUOTED_STRING(true),
        BACKTICK_STRING(true),
        SEPARATE(false),
        COMMENT(false),
        FUNC_DOCS(false);

        public final boolean isString;

        private TokenType(boolean isString) {
            this.isString = isString;
        }
    }
}

