/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.core.BCCoreItems;
import buildcraft.core.item.ItemMapLocation;
import buildcraft.core.item.ItemPaintbrush_BC8;
import buildcraft.lib.delta.DeltaInt;
import buildcraft.lib.delta.DeltaManager;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.MessageManager;
import buildcraft.lib.net.MessageUpdateTile;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.robotics.zone.ZonePlan;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileZonePlanner
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    protected static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("zone_planner");
    public static final int NET_PLAN_CHANGE = IDS.allocId("PLAN_CHANGE");
    public final ItemHandlerSimple invPaintbrushes;
    public final ItemHandlerSimple invInputPaintbrush;
    public final ItemHandlerSimple invInputMapLocation;
    public final ItemHandlerSimple invInputResult;
    public final ItemHandlerSimple invOutputPaintbrush;
    public final ItemHandlerSimple invOutputMapLocation;
    public final ItemHandlerSimple invOutputResult;
    private int progressInput;
    public final DeltaInt deltaProgressInput;
    private int progressOutput;
    public final DeltaInt deltaProgressOutput;
    public ZonePlan[] layers;

    public TileZonePlanner() {
        this.invPaintbrushes = this.itemManager.addInvHandler("paintbrushes", 16, (slot, stack) -> stack.func_77973_b() instanceof ItemPaintbrush_BC8, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
        this.invInputPaintbrush = this.itemManager.addInvHandler("inputPaintbrush", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemPaintbrush_BC8, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
        this.invInputMapLocation = this.itemManager.addInvHandler("inputMapLocation", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemMapLocation && Optional.ofNullable(stack.func_77978_p()).map(tagCompound -> tagCompound.func_74764_b("chunkMapping")).orElse(false) != false && stack.func_190916_E() == 1, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
        this.invInputResult = this.itemManager.addInvHandler("inputResult", 1, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
        this.invOutputPaintbrush = this.itemManager.addInvHandler("outputPaintbrush", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemPaintbrush_BC8, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
        this.invOutputMapLocation = this.itemManager.addInvHandler("outputMapLocation", 1, (slot, stack) -> stack.func_77973_b() instanceof ItemMapLocation && stack.func_190916_E() == 1, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
        this.invOutputResult = this.itemManager.addInvHandler("outputResult", 1, ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
        this.progressInput = 0;
        this.deltaProgressInput = this.deltaManager.addDelta("progressInput", DeltaManager.EnumNetworkVisibility.GUI_ONLY);
        this.progressOutput = 0;
        this.deltaProgressOutput = this.deltaManager.addDelta("progressOutput", DeltaManager.EnumNetworkVisibility.GUI_ONLY);
        this.layers = new ZonePlan[16];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new ZonePlan();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getLevel() {
        BlockPos blockPos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        while (!Minecraft.func_71410_x().field_71441_e.func_180495_p(blockPos).isSideSolid((IBlockAccess)Minecraft.func_71410_x().field_71441_e, blockPos, EnumFacing.DOWN) && blockPos.func_177956_o() < 255) {
            blockPos = new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o() + 1, blockPos.func_177952_p());
        }
        return (int)Math.floor((double)blockPos.func_177956_o() / 32.0);
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_RENDER_DATA) {
            for (ZonePlan layer : this.layers) {
                layer.writeToByteBuf(buffer);
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                for (int i = 0; i < this.layers.length; ++i) {
                    ZonePlan layer = this.layers[i];
                    this.layers[i] = layer.readFromByteBuf(buffer);
                }
            }
        } else if (side == Side.SERVER && id == NET_PLAN_CHANGE) {
            int index = buffer.readUnsignedShort();
            this.layers[index].readFromByteBuf(buffer);
            this.func_70296_d();
            this.sendNetworkUpdate(NET_RENDER_DATA);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        for (int i = 0; i < this.layers.length; ++i) {
            ZonePlan layer = this.layers[i];
            NBTTagCompound layerCompound = new NBTTagCompound();
            layer.writeToNBT(layerCompound);
            nbt.func_74782_a("layer_" + i, (NBTBase)layerCompound);
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < this.layers.length; ++i) {
            ZonePlan layer = this.layers[i];
            layer.readFromNBT(nbt.func_74775_l("layer_" + i));
        }
    }

    public void sendLayerToServer(int index) {
        MessageUpdateTile message = this.createMessage(NET_PLAN_CHANGE, buffer -> {
            buffer.writeShort(index);
            this.layers[index].writeToByteBuf(buffer);
        });
        MessageManager.sendToServer(message);
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("progress_input = " + this.progressInput);
        left.add("progress_output = " + this.progressOutput);
    }

    public void func_73660_a() {
        this.deltaManager.tick();
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (!this.invInputPaintbrush.getStackInSlot(0).func_190926_b() && this.invInputPaintbrush.getStackInSlot(0).func_77973_b() instanceof ItemPaintbrush_BC8 && !this.invInputMapLocation.getStackInSlot(0).func_190926_b() && this.invInputMapLocation.getStackInSlot(0).func_77973_b() instanceof ItemMapLocation && this.invInputMapLocation.getStackInSlot(0).func_77978_p() != null && this.invInputMapLocation.getStackInSlot(0).func_77978_p().func_74764_b("chunkMapping") && this.invInputResult.getStackInSlot(0).func_190926_b()) {
            if (this.progressInput == 0) {
                this.deltaProgressInput.addDelta(0L, 200L, 1);
                this.deltaProgressInput.addDelta(200L, 205L, -1);
            }
            if (this.progressInput < 200) {
                ++this.progressInput;
                return;
            }
            ZonePlan zonePlan = new ZonePlan();
            zonePlan.readFromNBT(this.invInputMapLocation.getStackInSlot(0).func_77978_p());
            this.layers[BCCoreItems.paintbrush.getBrushFromStack((ItemStack)this.invInputPaintbrush.getStackInSlot((int)0)).colour.func_176765_a()] = zonePlan.getWithOffset(-this.field_174879_c.func_177958_n(), -this.field_174879_c.func_177952_p());
            this.invInputMapLocation.setStackInSlot(0, StackUtil.EMPTY);
            this.invInputResult.setStackInSlot(0, new ItemStack((Item)BCCoreItems.mapLocation));
            this.func_70296_d();
            this.sendNetworkUpdate(NET_RENDER_DATA);
            this.progressInput = 0;
        } else if (this.progressInput != -1) {
            this.progressInput = -1;
            this.deltaProgressInput.setValue(0);
        }
        if (!this.invOutputPaintbrush.getStackInSlot(0).func_190926_b() && this.invOutputPaintbrush.getStackInSlot(0).func_77973_b() instanceof ItemPaintbrush_BC8 && !this.invOutputMapLocation.getStackInSlot(0).func_190926_b() && this.invOutputMapLocation.getStackInSlot(0).func_77973_b() instanceof ItemMapLocation && this.invOutputResult.getStackInSlot(0).func_190926_b()) {
            if (this.progressOutput == 0) {
                this.deltaProgressOutput.addDelta(0L, 200L, 1);
                this.deltaProgressOutput.addDelta(200L, 205L, -1);
            }
            if (this.progressOutput < 200) {
                ++this.progressOutput;
                return;
            }
            ItemMapLocation.setZone(this.invOutputMapLocation.getStackInSlot(0), this.layers[BCCoreItems.paintbrush.getBrushFromStack((ItemStack)this.invOutputPaintbrush.getStackInSlot((int)0)).colour.func_176765_a()].getWithOffset(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p()));
            this.invOutputResult.setStackInSlot(0, this.invOutputMapLocation.getStackInSlot(0));
            this.invOutputMapLocation.setStackInSlot(0, StackUtil.EMPTY);
            this.progressOutput = 0;
        } else if (this.progressOutput != -1) {
            this.progressOutput = -1;
            this.deltaProgressOutput.setValue(0);
        }
    }
}

