/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gate;

import buildcraft.api.BCModules;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.gates.IGate;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IActionInternalSided;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerInternalSided;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.statements.StatementSlot;
import buildcraft.api.statements.containers.IRedstoneStatementContainer;
import buildcraft.api.transport.IWireEmitter;
import buildcraft.api.transport.IWireManager;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeEventActionActivate;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.statement.ActionWrapper;
import buildcraft.lib.statement.FullStatement;
import buildcraft.lib.statement.TriggerWrapper;
import buildcraft.silicon.gate.ActionType;
import buildcraft.silicon.gate.EnumGateLogic;
import buildcraft.silicon.gate.GateVariant;
import buildcraft.silicon.gate.TriggerType;
import buildcraft.silicon.plug.PluggableGate;
import buildcraft.transport.wire.WorldSavedDataWireSystems;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class GateLogic
implements IGate,
IWireEmitter,
IRedstoneStatementContainer {
    protected static final IdAllocator ID_ALLOC = new IdAllocator("GateLogic");
    public static final int NET_ID_RESOLVE = ID_ALLOC.allocId("RESOLVE");
    public static final int NET_ID_CHANGE = ID_ALLOC.allocId("STATEMENT_CHANGE");
    public static final int NET_ID_GLOWING = ID_ALLOC.allocId("GLOWING");
    public static final int NET_ID_DARK = ID_ALLOC.allocId("DARK");
    @Deprecated
    public final PluggableGate pluggable;
    public final GateVariant variant;
    public final StatementPair[] statements;
    public final List<StatementSlot> activeActions = new ArrayList<StatementSlot>();
    public final boolean[] connections;
    public final boolean[] triggerOn;
    public final boolean[] actionOn;
    public int redstoneOutput;
    public int redstoneOutputSide;
    private final EnumSet<EnumDyeColor> wireBroadcasts;
    public boolean isOn;

    public GateLogic(PluggableGate pluggable, GateVariant variant) {
        this.pluggable = pluggable;
        this.variant = variant;
        this.statements = new StatementPair[variant.numSlots];
        for (int s = 0; s < variant.numSlots; ++s) {
            this.statements[s] = new StatementPair(s);
        }
        this.connections = new boolean[variant.numSlots - 1];
        this.triggerOn = new boolean[variant.numSlots];
        this.actionOn = new boolean[variant.numSlots];
        this.wireBroadcasts = EnumSet.noneOf(EnumDyeColor.class);
    }

    public GateLogic(PluggableGate pluggable, NBTTagCompound nbt) {
        this(pluggable, new GateVariant(nbt.func_74775_l("variant")));
        int i;
        short c = nbt.func_74765_d("connections");
        for (i = 0; i < this.connections.length; ++i) {
            this.connections[i] = (c >>> i & 1) == 1;
        }
        for (i = 0; i < this.statements.length; ++i) {
            NBTTagCompound nbt2;
            String tName = "trigger[" + i + "]";
            String aName = "action[" + i + "]";
            if (nbt.func_150297_b(tName, 8)) {
                nbt2 = new NBTTagCompound();
                nbt2.func_74778_a("kind", nbt.func_74779_i(tName));
                nbt2.func_74774_a("side", nbt.func_74771_c(tName + ".side"));
                nbt.func_74782_a(tName, (NBTBase)nbt2);
            }
            if (nbt.func_150297_b(aName, 8)) {
                nbt2 = new NBTTagCompound();
                nbt2.func_74778_a("kind", nbt.func_74779_i(aName));
                nbt2.func_74774_a("side", nbt.func_74771_c(aName + ".side"));
                nbt.func_74782_a(aName, (NBTBase)nbt2);
            }
            this.statements[i].trigger.readFromNbt(nbt.func_74775_l(tName));
            this.statements[i].action.readFromNbt(nbt.func_74775_l(aName));
        }
        this.wireBroadcasts.addAll(NBTUtilBC.readEnumSet(nbt.func_74781_a("wireBroadcasts"), EnumDyeColor.class));
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("variant", (NBTBase)this.variant.writeToNBT());
        short c = 0;
        for (int i = 0; i < this.connections.length; ++i) {
            if (!this.connections[i]) continue;
            c = (short)(c | 1 << i);
        }
        nbt.func_74777_a("connections", c);
        for (int s = 0; s < this.statements.length; ++s) {
            nbt.func_74782_a("trigger[" + s + "]", (NBTBase)this.statements[s].trigger.writeToNbt());
            nbt.func_74782_a("action[" + s + "]", (NBTBase)this.statements[s].action.writeToNbt());
        }
        nbt.func_74782_a("wireBroadcasts", NBTUtilBC.writeEnumSet(this.wireBroadcasts, EnumDyeColor.class));
        return nbt;
    }

    public GateLogic(PluggableGate pluggable, PacketBufferBC buffer) {
        this(pluggable, new GateVariant(buffer));
        MessageUtil.readBooleanArray((PacketBuffer)buffer, this.triggerOn);
        MessageUtil.readBooleanArray((PacketBuffer)buffer, this.actionOn);
        MessageUtil.readBooleanArray((PacketBuffer)buffer, this.connections);
        try {
            for (StatementPair pair : this.statements) {
                pair.trigger.readFromBuffer(buffer);
                pair.action.readFromBuffer(buffer);
            }
        }
        catch (IOException io) {
            throw new Error(io);
        }
        boolean on = false;
        for (int i = 0; i < this.statements.length; ++i) {
            boolean b = this.actionOn[i];
            on |= b && this.statements[i].action.get() != null;
        }
        this.isOn = on;
    }

    public void writeCreationToBuf(PacketBufferBC buffer) {
        this.variant.writeToBuffer(buffer);
        MessageUtil.writeBooleanArray(buffer, this.triggerOn);
        MessageUtil.writeBooleanArray(buffer, this.actionOn);
        MessageUtil.writeBooleanArray(buffer, this.connections);
        for (StatementPair pair : this.statements) {
            pair.trigger.writeToBuffer(buffer);
            pair.action.writeToBuffer(buffer);
        }
    }

    public void readPayload(PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        short id = buffer.readUnsignedByte();
        if (id == NET_ID_CHANGE) {
            boolean isAction = buffer.readBoolean();
            short slot = buffer.readUnsignedByte();
            if (slot < 0 || slot >= this.statements.length) {
                throw new InvalidInputDataException("Slot index out of range! (" + slot + ", must be within " + this.statements.length + ")");
            }
            StatementPair s = this.statements[slot];
            (isAction ? s.action : s.trigger).readFromBuffer(buffer);
            return;
        }
        if (side == Side.CLIENT) {
            if (id == NET_ID_RESOLVE) {
                MessageUtil.readBooleanArray((PacketBuffer)buffer, this.triggerOn);
                MessageUtil.readBooleanArray((PacketBuffer)buffer, this.actionOn);
                MessageUtil.readBooleanArray((PacketBuffer)buffer, this.connections);
            } else if (id == NET_ID_GLOWING) {
                this.isOn = true;
            } else if (id == NET_ID_DARK) {
                this.isOn = false;
            } else {
                BCLog.logger.warn("Unknown ID " + ID_ALLOC.getNameFor(id));
            }
        } else {
            BCLog.logger.warn("Unknown side " + side + " + ID " + ID_ALLOC.getNameFor(id));
        }
    }

    public void sendStatementUpdate(boolean isAction, int slot) {
        this.pluggable.sendGuiMessage(buffer -> {
            buffer.writeByte(NET_ID_CHANGE);
            buffer.writeBoolean(isAction);
            buffer.writeByte(slot);
            StatementPair s = this.statements[slot];
            (isAction ? s.action : s.trigger).writeToBuffer(buffer);
        });
    }

    public void sendResolveData() {
        this.pluggable.sendGuiMessage(buffer -> {
            buffer.writeByte(NET_ID_RESOLVE);
            MessageUtil.writeBooleanArray(buffer, this.triggerOn);
            MessageUtil.writeBooleanArray(buffer, this.actionOn);
            MessageUtil.writeBooleanArray(buffer, this.connections);
        });
    }

    public void sendIsOn() {
        this.pluggable.sendMessage(buffer -> buffer.writeByte(this.isOn ? NET_ID_GLOWING : NET_ID_DARK));
    }

    @Override
    public EnumFacing getSide() {
        return this.pluggable.side;
    }

    @Override
    public TileEntity getTile() {
        return this.getPipeHolder().getPipeTile();
    }

    @Override
    public TileEntity getNeighbourTile(EnumFacing side) {
        return this.getPipeHolder().getNeighbourTile(side);
    }

    @Override
    public IPipeHolder getPipeHolder() {
        return this.pluggable.holder;
    }

    @Override
    public List<IStatement> getTriggers() {
        ArrayList<IStatement> list = new ArrayList<IStatement>(this.statements.length);
        for (StatementPair pair : this.statements) {
            TriggerWrapper e = (TriggerWrapper)pair.trigger.get();
            list.add(e == null ? e : e.delegate);
        }
        return list;
    }

    @Override
    public List<IStatement> getActions() {
        ArrayList<IStatement> list = new ArrayList<IStatement>(this.statements.length);
        for (StatementPair pair : this.statements) {
            ActionWrapper e = (ActionWrapper)pair.action.get();
            list.add(e == null ? e : e.delegate);
        }
        return list;
    }

    @Override
    public List<StatementSlot> getActiveActions() {
        return this.activeActions;
    }

    @Override
    public List<IStatementParameter> getTriggerParameters(int slot) {
        return Arrays.asList(this.statements[slot].trigger.getParameters());
    }

    @Override
    public List<IStatementParameter> getActionParameters(int slot) {
        return Arrays.asList(this.statements[slot].action.getParameters());
    }

    @Override
    public int getRedstoneInput(EnumFacing side) {
        return this.getPipeHolder().getRedstoneInput(side);
    }

    @Override
    public boolean setRedstoneOutput(EnumFacing side, int value) {
        return this.getPipeHolder().setRedstoneOutput(side, value);
    }

    @Override
    public boolean isEmitting(EnumDyeColor colour) {
        TileEntity tile = this.getPipeHolder().getPipeTile();
        if (tile.func_145837_r()) {
            throw new UnsupportedOperationException("Cannot check an invalid emitter!");
        }
        return this.wireBroadcasts.contains(colour);
    }

    @Override
    public void emitWire(EnumDyeColor colour) {
        this.wireBroadcasts.add(colour);
    }

    public boolean isSplitInTwo() {
        return this.variant.numSlots > 4;
    }

    public void resolveActions() {
        int groupCount = 0;
        int groupActive = 0;
        boolean prevIsOn = this.isOn;
        this.isOn = false;
        boolean[] prevTriggers = Arrays.copyOf(this.triggerOn, this.triggerOn.length);
        boolean[] prevActions = Arrays.copyOf(this.actionOn, this.actionOn.length);
        Arrays.fill(this.triggerOn, false);
        Arrays.fill(this.actionOn, false);
        this.activeActions.clear();
        EnumSet<EnumDyeColor> previousBroadcasts = EnumSet.copyOf(this.wireBroadcasts);
        this.wireBroadcasts.clear();
        for (int triggerIndex = 0; triggerIndex < this.statements.length; ++triggerIndex) {
            StatementPair pair = this.statements[triggerIndex];
            TriggerWrapper trigger = (TriggerWrapper)pair.trigger.get();
            ++groupCount;
            if (trigger != null) {
                IStatementParameter[] params = new IStatementParameter[pair.trigger.getParamCount()];
                for (int p = 0; p < pair.trigger.getParamCount(); ++p) {
                    params[p] = pair.trigger.getParamRef(p).get();
                }
                if (trigger.isTriggerActive(this, params)) {
                    ++groupActive;
                    this.triggerOn[triggerIndex] = true;
                }
            }
            if (this.connections.length != triggerIndex && this.connections[triggerIndex]) continue;
            boolean allActionsActive = this.variant.logic == EnumGateLogic.AND ? groupActive == groupCount : groupActive > 0;
            for (int i = groupCount - 1; i >= 0; --i) {
                int actionIndex = triggerIndex - i;
                StatementPair fullAction = this.statements[actionIndex];
                ActionWrapper action = (ActionWrapper)fullAction.action.get();
                this.actionOn[actionIndex] = allActionsActive;
                if (action == null) continue;
                if (allActionsActive) {
                    this.isOn = true;
                    StatementSlot slot = new StatementSlot();
                    slot.statement = action.delegate;
                    slot.parameters = (IStatementParameter[])fullAction.action.getParameters().clone();
                    slot.part = action.sourcePart;
                    this.activeActions.add(slot);
                    action.actionActivate(this, slot.parameters);
                    PipeEventActionActivate evt = new PipeEventActionActivate(this.getPipeHolder(), action.getDelegate(), slot.parameters, action.sourcePart);
                    this.getPipeHolder().fireEvent(evt);
                    continue;
                }
                action.actionDeactivated(this, fullAction.action.getParameters());
            }
            groupActive = 0;
            groupCount = 0;
        }
        if (!previousBroadcasts.equals(this.wireBroadcasts)) {
            IWireManager wires = this.getPipeHolder().getWireManager();
            EnumSet<EnumDyeColor> turnedOff = EnumSet.copyOf(previousBroadcasts);
            turnedOff.removeAll(this.wireBroadcasts);
            EnumSet<EnumDyeColor> turnedOn = EnumSet.copyOf(this.wireBroadcasts);
            turnedOn.removeAll(previousBroadcasts);
            if (BCModules.TRANSPORT.isLoaded() && !this.getPipeHolder().getPipeWorld().field_72995_K) {
                WorldSavedDataWireSystems.get((World)this.getPipeHolder().getPipeWorld()).gatesChanged = true;
            }
        }
        if (this.isOn != prevIsOn) {
            this.sendIsOn();
        }
        if (!Arrays.equals(prevTriggers, this.triggerOn) || !Arrays.equals(prevActions, this.actionOn)) {
            this.sendResolveData();
        }
    }

    public void onTick() {
        if (this.getPipeHolder().getPipeWorld().field_72995_K) {
            return;
        }
        this.resolveActions();
    }

    public SortedSet<TriggerWrapper> getAllValidTriggers() {
        TreeSet<TriggerWrapper> set = new TreeSet<TriggerWrapper>();
        for (ITriggerInternal trigger : StatementManager.getInternalTriggers(this)) {
            if (!this.isValidTrigger(trigger)) continue;
            set.add(new TriggerWrapper.TriggerWrapperInternal(trigger));
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            for (ITriggerInternalSided trigger : StatementManager.getInternalSidedTriggers(this, face)) {
                if (!this.isValidTrigger(trigger)) continue;
                set.add(new TriggerWrapper.TriggerWrapperInternalSided(trigger, face));
            }
            TileEntity neighbour = this.getNeighbourTile(face);
            if (neighbour == null) continue;
            for (ITriggerExternal trigger : StatementManager.getExternalTriggers(face, neighbour)) {
                if (!this.isValidTrigger(trigger)) continue;
                set.add(new TriggerWrapper.TriggerWrapperExternal(trigger, face));
            }
        }
        return set;
    }

    public SortedSet<ActionWrapper> getAllValidActions() {
        TreeSet<ActionWrapper> set = new TreeSet<ActionWrapper>();
        for (IActionInternal trigger : StatementManager.getInternalActions(this)) {
            if (!this.isValidAction(trigger)) continue;
            set.add(new ActionWrapper.ActionWrapperInternal(trigger));
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            for (IActionInternalSided trigger : StatementManager.getInternalSidedActions(this, face)) {
                if (!this.isValidAction(trigger)) continue;
                set.add(new ActionWrapper.ActionWrapperInternalSided(trigger, face));
            }
            TileEntity neighbour = this.getNeighbourTile(face);
            if (neighbour == null) continue;
            for (IActionExternal trigger : StatementManager.getExternalActions(face, neighbour)) {
                if (!this.isValidAction(trigger)) continue;
                set.add(new ActionWrapper.ActionWrapperExternal(trigger, face));
            }
        }
        return set;
    }

    public boolean isValidTrigger(IStatement statement) {
        return statement != null && statement.minParameters() <= this.variant.numTriggerArgs;
    }

    public boolean isValidAction(IStatement statement) {
        return statement != null && statement.minParameters() <= this.variant.numActionArgs;
    }

    public class StatementPair {
        public final FullStatement<TriggerWrapper> trigger;
        public final FullStatement<ActionWrapper> action;

        public StatementPair(int index) {
            FullStatement.IStatementChangeListener tChange = (s, i) -> GateLogic.this.sendStatementUpdate(false, index);
            FullStatement.IStatementChangeListener aChange = (s, i) -> GateLogic.this.sendStatementUpdate(true, index);
            this.trigger = new FullStatement<TriggerWrapper>(TriggerType.INSTANCE, GateLogic.this.variant.numTriggerArgs, tChange);
            this.action = new FullStatement<ActionWrapper>(ActionType.INSTANCE, GateLogic.this.variant.numActionArgs, aChange);
        }
    }
}

