/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.tile;

import buildcraft.api.BCModules;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.transport.EnumWirePart;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.api.transport.pipe.PipeEvent;
import buildcraft.api.transport.pipe.PipeEventTileState;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.silicon.plug.FilterEventHandler;
import buildcraft.transport.BCTransportBlocks;
import buildcraft.transport.pipe.Pipe;
import buildcraft.transport.pipe.PipeEventBus;
import buildcraft.transport.pipe.PluggableHolder;
import buildcraft.transport.wire.WireManager;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TilePipeHolder
extends TileBC_Neptune
implements IPipeHolder,
ITickable,
IDebuggable {
    protected static final IdAllocator IDS = TileBC_Neptune.IDS.makeChild("pipe");
    public static final int NET_UPDATE_MULTI = IDS.allocId("UPDATE_MULTI");
    public static final int NET_UPDATE_PIPE_BEHAVIOUR = TilePipeHolder.getReceiverId(IPipeHolder.PipeMessageReceiver.BEHAVIOUR);
    public static final int NET_UPDATE_PIPE_FLOW = TilePipeHolder.getReceiverId(IPipeHolder.PipeMessageReceiver.FLOW);
    public static final int NET_UPDATE_PLUG_DOWN = TilePipeHolder.getReceiverId(IPipeHolder.PipeMessageReceiver.PLUGGABLE_DOWN);
    public static final int NET_UPDATE_PLUG_UP = TilePipeHolder.getReceiverId(IPipeHolder.PipeMessageReceiver.PLUGGABLE_UP);
    public static final int NET_UPDATE_PLUG_NORTH = TilePipeHolder.getReceiverId(IPipeHolder.PipeMessageReceiver.PLUGGABLE_NORTH);
    public static final int NET_UPDATE_PLUG_SOUTH = TilePipeHolder.getReceiverId(IPipeHolder.PipeMessageReceiver.PLUGGABLE_SOUTH);
    public static final int NET_UPDATE_PLUG_WEST = TilePipeHolder.getReceiverId(IPipeHolder.PipeMessageReceiver.PLUGGABLE_WEST);
    public static final int NET_UPDATE_PLUG_EAST = TilePipeHolder.getReceiverId(IPipeHolder.PipeMessageReceiver.PLUGGABLE_EAST);
    public static final int NET_UPDATE_WIRES = TilePipeHolder.getReceiverId(IPipeHolder.PipeMessageReceiver.WIRES);
    private int[] redstoneValues = new int[6];
    private int[] oldRedstoneValues = new int[]{-1, -1, -1, -1, -1, -1};
    public static final int[] NET_UPDATE_PLUGS;
    public final WireManager wireManager = new WireManager(this);
    public final PipeEventBus eventBus = new PipeEventBus();
    private final Map<EnumFacing, PluggableHolder> pluggables = new EnumMap<EnumFacing, PluggableHolder>(EnumFacing.class);
    private Pipe pipe;
    private boolean scheduleRenderUpdate = true;
    private final Set<IPipeHolder.PipeMessageReceiver> networkUpdates = EnumSet.noneOf(IPipeHolder.PipeMessageReceiver.class);
    private final Set<IPipeHolder.PipeMessageReceiver> networkGuiUpdates = EnumSet.noneOf(IPipeHolder.PipeMessageReceiver.class);
    private final Map<EnumFacing, WeakReference<TileEntity>> neighbourTiles = new EnumMap<EnumFacing, WeakReference<TileEntity>>(EnumFacing.class);
    private NBTTagCompound unknownData;

    @Override
    public IdAllocator getIdAllocator() {
        return IDS;
    }

    private static int getReceiverId(IPipeHolder.PipeMessageReceiver type) {
        return NET_UPDATE_MULTI + 1 + type.ordinal();
    }

    public TilePipeHolder() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.pluggables.put(side, new PluggableHolder(this, side));
        }
        this.caps.addCapabilityInstance(PipeApi.CAP_PIPE_HOLDER, this, EnumPipePart.VALUES);
        this.caps.addCapability(PipeApi.CAP_PIPE, this::getPipe, EnumPipePart.VALUES);
        this.caps.addCapability(PipeApi.CAP_PLUG, this::getPluggable, EnumPipePart.FACES);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.pipe != null) {
            nbt.func_74782_a("pipe", (NBTBase)this.pipe.writeToNbt());
        }
        NBTTagCompound plugs = new NBTTagCompound();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            NBTTagCompound plugTag = this.pluggables.get(face).writeToNbt();
            if (plugTag.func_82582_d()) continue;
            plugs.func_74782_a(face.func_176610_l(), (NBTBase)plugTag);
        }
        if (!plugs.func_82582_d()) {
            nbt.func_74782_a("plugs", (NBTBase)plugs);
        }
        nbt.func_74782_a("wireManager", (NBTBase)this.wireManager.writeToNbt());
        nbt.func_74783_a("redstone", this.redstoneValues);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        int[] temp;
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("pipe")) {
            try {
                this.pipe = new Pipe((IPipeHolder)this, nbt.func_74775_l("pipe"));
                this.eventBus.registerHandler(this.pipe.behaviour);
                this.eventBus.registerHandler(this.pipe.flow);
                if (this.pipe.flow instanceof IFlowItems && BCModules.SILICON.isLoaded()) {
                    this.eventBus.registerHandler(FilterEventHandler.class);
                }
            }
            catch (InvalidInputDataException e) {
                e.printStackTrace();
                this.unknownData = nbt.func_74737_b();
            }
        }
        NBTTagCompound plugs = nbt.func_74775_l("plugs");
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.pluggables.get(face).readFromNbt(plugs.func_74775_l(face.func_176610_l()));
        }
        this.wireManager.readFromNbt(nbt.func_74775_l("wireManager"));
        if (nbt.func_74764_b("redstone") && (temp = nbt.func_74759_k("redstone")).length == 6) {
            this.redstoneValues = temp;
        }
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        super.onPlacedBy(placer, stack);
        Item item = stack.func_77973_b();
        if (item instanceof IItemPipe) {
            int meta;
            PipeDefinition definition = ((IItemPipe)item).getDefinition();
            this.pipe = new Pipe((IPipeHolder)this, definition);
            this.eventBus.registerHandler(this.pipe.behaviour);
            this.eventBus.registerHandler(this.pipe.flow);
            if (this.pipe.flow instanceof IFlowItems && BCModules.SILICON.isLoaded()) {
                this.eventBus.registerHandler(FilterEventHandler.class);
            }
            if ((meta = stack.func_77960_j()) > 0 && meta <= 16) {
                this.pipe.setColour(EnumDyeColor.func_176764_b((int)(meta - 1)));
            }
        }
        this.scheduleRenderUpdate();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.eventBus.fireEvent(new PipeEventTileState.Invalidate(this));
        this.wireManager.invalidate();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.eventBus.fireEvent(new PipeEventTileState.Validate(this));
        this.wireManager.validate();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.eventBus.fireEvent(new PipeEventTileState.ChunkUnload(this));
    }

    public void onLoad() {
        super.onLoad();
        if (this.pipe != null) {
            this.pipe.onLoad();
        }
        this.wireManager.validate();
    }

    @Override
    public void onNeighbourBlockChanged(Block block, BlockPos nehighbour) {
        super.onNeighbourBlockChanged(block, nehighbour);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            TileEntity tile;
            WeakReference<TileEntity> current = this.neighbourTiles.get(face);
            if (current != null) {
                tile = (TileEntity)current.get();
                if (tile != null && !tile.func_145837_r()) continue;
                this.neighbourTiles.remove(face);
            }
            if ((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(face))) == null) continue;
            this.neighbourTiles.put(face, new WeakReference<TileEntity>(tile));
        }
        if (this.pipe != null) {
            this.pipe.markForUpdate();
        }
    }

    public void func_73660_a() {
        EnumSet<IPipeHolder.PipeMessageReceiver> parts;
        this.redstoneValues = new int[6];
        if (this.pipe != null) {
            this.pipe.onTick();
        }
        for (EnumFacing face : EnumFacing.field_82609_l) {
            this.pluggables.get(face).onTick();
        }
        if (this.networkUpdates.size() > 0) {
            parts = EnumSet.copyOf(this.networkUpdates);
            for (IPipeHolder.PipeMessageReceiver part : parts) {
                this.sendNetworkUpdate(TilePipeHolder.getReceiverId(part));
            }
        }
        this.networkGuiUpdates.removeAll(this.networkUpdates);
        this.networkUpdates.clear();
        if (this.networkGuiUpdates.size() > 0) {
            parts = EnumSet.copyOf(this.networkGuiUpdates);
            for (IPipeHolder.PipeMessageReceiver part : parts) {
                this.sendNetworkGuiUpdate(TilePipeHolder.getReceiverId(part));
            }
        }
        this.networkGuiUpdates.clear();
        if (this.scheduleRenderUpdate) {
            this.scheduleRenderUpdate = false;
            this.redrawBlock();
        }
        this.wireManager.tick();
        if (!Arrays.equals(this.redstoneValues, this.oldRedstoneValues)) {
            Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            this.field_145850_b.func_175685_c(this.field_174879_c, block, true);
            for (int i = 0; i < 6; ++i) {
                EnumFacing face = EnumFacing.field_82609_l[i];
                if (this.oldRedstoneValues[i] == this.redstoneValues[i]) continue;
                this.field_145850_b.func_175685_c(this.field_174879_c.func_177972_a(face), block, true);
            }
            this.oldRedstoneValues = this.redstoneValues;
        }
        this.markChunkDirty();
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                if (this.pipe == null) {
                    buffer.writeBoolean(false);
                } else {
                    buffer.writeBoolean(true);
                    this.pipe.writeCreationPayload(buffer);
                }
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    this.pluggables.get(face).writeCreationPayload(buffer);
                }
                this.wireManager.writePayload(buffer, side);
            } else if (id == NET_UPDATE_PIPE_BEHAVIOUR) {
                if (this.pipe == null) {
                    buffer.writeBoolean(false);
                } else {
                    buffer.writeBoolean(true);
                    this.pipe.writePayload(buffer, side);
                }
            } else if (id == NET_UPDATE_WIRES) {
                this.wireManager.writePayload(buffer, side);
            }
        }
        if (id == NET_UPDATE_PIPE_FLOW) {
            if (this.pipe == null || this.pipe.flow == null) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                this.pipe.flow.writePayload(1, buffer, side);
            }
        } else if (id == NET_UPDATE_PLUG_DOWN) {
            this.pluggables.get(EnumFacing.DOWN).writePayload(buffer, side);
        } else if (id == NET_UPDATE_PLUG_UP) {
            this.pluggables.get(EnumFacing.UP).writePayload(buffer, side);
        } else if (id == NET_UPDATE_PLUG_NORTH) {
            this.pluggables.get(EnumFacing.NORTH).writePayload(buffer, side);
        } else if (id == NET_UPDATE_PLUG_SOUTH) {
            this.pluggables.get(EnumFacing.SOUTH).writePayload(buffer, side);
        } else if (id == NET_UPDATE_PLUG_WEST) {
            this.pluggables.get(EnumFacing.WEST).writePayload(buffer, side);
        } else if (id == NET_UPDATE_PLUG_EAST) {
            this.pluggables.get(EnumFacing.EAST).writePayload(buffer, side);
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                if (buffer.readBoolean()) {
                    this.pipe = new Pipe(this, buffer, ctx);
                    this.eventBus.registerHandler(this.pipe.behaviour);
                    this.eventBus.registerHandler(this.pipe.flow);
                    if (this.pipe.flow instanceof IFlowItems && BCModules.SILICON.isLoaded()) {
                        this.eventBus.registerHandler(FilterEventHandler.class);
                    }
                } else if (this.pipe != null) {
                    this.eventBus.unregisterHandler(this.pipe.behaviour);
                    this.eventBus.unregisterHandler(this.pipe.flow);
                    this.pipe = null;
                }
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    this.pluggables.get(face).readCreationPayload(buffer);
                }
                this.wireManager.readPayload(buffer, side, ctx);
            } else if (id == NET_UPDATE_MULTI) {
                short total = buffer.readUnsignedByte();
                for (IPipeHolder.PipeMessageReceiver type : IPipeHolder.PipeMessageReceiver.VALUES) {
                    if ((total >> type.ordinal() & 1) != 1) continue;
                    this.readPayload(TilePipeHolder.getReceiverId(type), buffer, side, ctx);
                }
            } else if (id == NET_UPDATE_PIPE_BEHAVIOUR) {
                if (buffer.readBoolean()) {
                    if (this.pipe == null) {
                        throw new IllegalStateException("Pipe was null when it shouldn't have been!");
                    }
                    this.pipe.readPayload(buffer, side, ctx);
                }
            } else if (id == NET_UPDATE_WIRES) {
                this.wireManager.readPayload(buffer, side, ctx);
            }
        }
        if (id == NET_UPDATE_PIPE_FLOW) {
            if (buffer.readBoolean()) {
                if (this.pipe == null) {
                    throw new IllegalStateException("Pipe was null when it shouldn't have been!");
                }
                short fId = buffer.readShort();
                this.pipe.flow.readPayload(fId, buffer, side);
            }
        } else if (id == NET_UPDATE_PLUG_DOWN) {
            this.pluggables.get(EnumFacing.DOWN).readPayload(buffer, side, ctx);
        } else if (id == NET_UPDATE_PLUG_UP) {
            this.pluggables.get(EnumFacing.UP).readPayload(buffer, side, ctx);
        } else if (id == NET_UPDATE_PLUG_NORTH) {
            this.pluggables.get(EnumFacing.NORTH).readPayload(buffer, side, ctx);
        } else if (id == NET_UPDATE_PLUG_SOUTH) {
            this.pluggables.get(EnumFacing.SOUTH).readPayload(buffer, side, ctx);
        } else if (id == NET_UPDATE_PLUG_WEST) {
            this.pluggables.get(EnumFacing.WEST).readPayload(buffer, side, ctx);
        } else if (id == NET_UPDATE_PLUG_EAST) {
            this.pluggables.get(EnumFacing.EAST).readPayload(buffer, side, ctx);
        }
    }

    @Override
    public World getPipeWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getPipePos() {
        return this.func_174877_v();
    }

    @Override
    public TileEntity getPipeTile() {
        return this;
    }

    @Override
    public Pipe getPipe() {
        return this.pipe;
    }

    @Override
    public boolean canPlayerInteract(EntityPlayer player) {
        return this.canInteractWith(player);
    }

    @Override
    public PipePluggable getPluggable(EnumFacing side) {
        if (side == null) {
            return null;
        }
        return this.pluggables.get((Object)side).pluggable;
    }

    public PipePluggable replacePluggable(EnumFacing side, PipePluggable with) {
        this.redstoneValues = new int[6];
        PluggableHolder holder = this.pluggables.get(side);
        PipePluggable old = holder.pluggable;
        holder.pluggable = with;
        this.eventBus.unregisterHandler(old);
        this.eventBus.registerHandler(with);
        if (this.pipe != null) {
            this.pipe.markForUpdate();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (old != with) {
                this.wireManager.getWireSystems().rebuildWireSystemsAround(this);
            }
            holder.sendNewPluggableData();
        }
        this.scheduleRenderUpdate();
        this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(side), (Block)BCTransportBlocks.pipeHolder, this.field_174879_c);
        return old;
    }

    @Override
    public IPipe getNeighbourPipe(EnumFacing side) {
        TileEntity neighbour = this.getNeighbourTile(side);
        if (neighbour == null) {
            return null;
        }
        return (IPipe)neighbour.getCapability(PipeApi.CAP_PIPE, side.func_176734_d());
    }

    @Override
    public <T> T getCapabilityFromPipe(EnumFacing side, @Nonnull Capability<T> capability) {
        TileEntity neighbour;
        PipePluggable plug = this.getPluggable(side);
        if (plug != null) {
            T t = plug.getInternalCapability(capability);
            if (t != null) {
                return t;
            }
            if (plug.isBlocking()) {
                return null;
            }
        }
        if (this.pipe.isConnected(side) && (neighbour = this.getNeighbourTile(side)) != null) {
            return (T)neighbour.getCapability(capability, side.func_176734_d());
        }
        return null;
    }

    @Override
    public void scheduleRenderUpdate() {
        this.scheduleRenderUpdate = true;
    }

    @Override
    public void scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver ... parts) {
        Collections.addAll(this.networkUpdates, parts);
    }

    @Override
    public void scheduleNetworkGuiUpdate(IPipeHolder.PipeMessageReceiver ... parts) {
        Collections.addAll(this.networkGuiUpdates, parts);
    }

    @Override
    public void sendMessage(IPipeHolder.PipeMessageReceiver to, IPipeHolder.IWriter writer) {
        this.createAndSendMessage(TilePipeHolder.getReceiverId(to), writer::write);
    }

    @Override
    public void sendGuiMessage(IPipeHolder.PipeMessageReceiver to, IPipeHolder.IWriter writer) {
        this.createAndSendGuiMessage(TilePipeHolder.getReceiverId(to), writer::write);
    }

    @Override
    public WireManager getWireManager() {
        return this.wireManager;
    }

    @Override
    public boolean fireEvent(PipeEvent event) {
        return this.eventBus.fireEvent(event);
    }

    @Override
    public int getRedstoneInput(EnumFacing side) {
        if (side == null) {
            return this.field_145850_b.func_175687_A(this.field_174879_c);
        }
        return this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(side), side);
    }

    @Override
    public boolean setRedstoneOutput(EnumFacing side, int value) {
        if (side == null) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                this.redstoneValues[facing.ordinal()] = value;
            }
        } else {
            this.redstoneValues[side.ordinal()] = value;
        }
        return true;
    }

    public int getRedstoneOutput(EnumFacing side) {
        return this.redstoneValues[side.ordinal()];
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        T val;
        PipePluggable plug;
        if (facing != null && (plug = this.getPluggable(facing)) != null) {
            T cap = plug.getCapability(capability);
            if (cap != null) {
                return cap;
            }
            if (plug.isBlocking()) {
                return null;
            }
        }
        if (this.pipe != null && (val = this.pipe.getCapability(capability, facing)) != null) {
            return val;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        if (this.pipe == null) {
            left.add("Pipe = null");
        } else {
            left.add("Pipe:");
            this.pipe.getDebugInfo(left, right, side);
        }
        left.add("Parts:");
        this.wireManager.parts.forEach((part, color) -> left.add(" - " + (Object)part + " = " + color + " = " + this.wireManager.isPowered((EnumWirePart)((Object)part))));
        left.add("All wire systems in world count = " + (this.field_145850_b.field_72995_K ? 0 : this.wireManager.getWireSystems().wireSystems.size()));
        if (this.unknownData != null) {
            left.add(this.unknownData.toString());
        }
    }

    public boolean hasFastRenderer() {
        return true;
    }

    static {
        for (IPipeHolder.PipeMessageReceiver rec : IPipeHolder.PipeMessageReceiver.VALUES) {
            IDS.allocId("UPDATE_" + (Object)((Object)rec));
        }
        NET_UPDATE_PLUGS = new int[]{NET_UPDATE_PLUG_DOWN, NET_UPDATE_PLUG_UP, NET_UPDATE_PLUG_NORTH, NET_UPDATE_PLUG_SOUTH, NET_UPDATE_PLUG_WEST, NET_UPDATE_PLUG_EAST};
    }
}

